/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.message.FieldMessage;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageObserver;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.scope.ApplicationScope;
import org.primeframework.mvc.message.scope.FlashScope;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.message.scope.RequestScope;
import org.primeframework.mvc.message.scope.Scope;

public class DefaultMessageStore
implements MessageStore {
    private final HTTPRequest httpRequest;
    private final Map<MessageScope, Scope> scopes = new LinkedHashMap<MessageScope, Scope>();
    private MessageObserver observer;

    @Inject
    public DefaultMessageStore(ApplicationScope applicationScope, FlashScope flashScope, RequestScope requestScope, HTTPRequest httpRequest) {
        this.scopes.put(MessageScope.REQUEST, requestScope);
        this.scopes.put(MessageScope.FLASH, flashScope);
        this.scopes.put(MessageScope.APPLICATION, applicationScope);
        this.httpRequest = httpRequest;
    }

    @Override
    public void add(Message message) {
        this.add(MessageScope.REQUEST, message);
    }

    @Override
    public void add(MessageScope scope, Message message) {
        Scope s = this.scopes.get(scope);
        s.add(message);
        if (this.observer != null) {
            this.observer.messageAdded(this.httpRequest, scope, message);
        }
    }

    @Override
    public void addAll(MessageScope scope, Collection<Message> messages) {
        Scope s = this.scopes.get(scope);
        s.addAll(messages);
        if (this.observer != null) {
            messages.forEach(m -> this.observer.messageAdded(this.httpRequest, scope, (Message)m));
        }
    }

    @Override
    public void clear() {
        for (MessageScope scope : this.scopes.keySet()) {
            this.clear(scope);
        }
    }

    @Override
    public void clear(MessageScope scope) {
        this.scopes.get(scope).clear();
        if (this.observer != null) {
            this.observer.scopeCleared(this.httpRequest, scope);
        }
    }

    @Override
    public List<Message> get() {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Scope scope : this.scopes.values()) {
            messages.addAll(scope.get());
        }
        return messages;
    }

    @Override
    public List<Message> get(MessageScope scope) {
        Scope s = this.scopes.get(scope);
        return new ArrayList<Message>(s.get());
    }

    @Override
    public Map<String, List<FieldMessage>> getFieldMessages() {
        return this.getFieldMessages(null);
    }

    @Override
    public Map<String, List<FieldMessage>> getFieldMessages(MessageScope scope) {
        List<Message> messages = scope == null ? this.get() : this.get(scope);
        HashMap<String, List<FieldMessage>> map = new HashMap<String, List<FieldMessage>>();
        for (Message message : messages) {
            if (!(message instanceof FieldMessage)) continue;
            FieldMessage fm = (FieldMessage)message;
            List list = map.computeIfAbsent(fm.getField(), k -> new ArrayList());
            list.add(fm);
        }
        return map;
    }

    @Override
    public List<Message> getGeneralMessages() {
        List<Message> messages = this.get();
        ArrayList<Message> list = new ArrayList<Message>();
        for (Message message : messages) {
            if (message instanceof FieldMessage) continue;
            list.add(message);
        }
        return list;
    }

    @Inject(optional=true)
    public void setObserver(MessageObserver observer) {
        this.observer = observer;
    }
}

