/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.content.ContentHandler;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.util.ObjectTools;
import org.primeframework.mvc.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJacksonContentHandler
implements ContentHandler {
    private static final Pattern invalidEnumerationValue = Pattern.compile("Cannot deserialize value of type `\\S+` from \\S+ \"(\\S+)\": not one of the values accepted for Enum class: \\[(.*)]$.*", 40);
    private static final Logger logger = LoggerFactory.getLogger(BaseJacksonContentHandler.class);
    protected final ExpressionEvaluator expressionEvaluator;
    protected final MessageProvider messageProvider;
    protected final MessageStore messageStore;
    protected final ObjectMapper objectMapper;
    protected final HTTPRequest request;
    protected final ActionInvocationStore store;

    @Inject
    public BaseJacksonContentHandler(HTTPRequest request, ActionInvocationStore store, ObjectMapper objectMapper, ExpressionEvaluator expressionEvaluator, MessageProvider messageProvider, MessageStore messageStore) {
        this.request = request;
        this.store = store;
        this.objectMapper = objectMapper;
        this.expressionEvaluator = expressionEvaluator;
        this.messageProvider = messageProvider;
        this.messageStore = messageStore;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void handle() throws IOException {
        ActionInvocation actionInvocation = this.store.getCurrent();
        Object action = actionInvocation.action;
        if (action == null) {
            return;
        }
        ActionConfiguration config = actionInvocation.configuration;
        if (!config.additionalConfiguration.containsKey(JacksonActionConfiguration.class)) {
            return;
        }
        if (!this.request.hasBody()) {
            return;
        }
        String contentType = this.request.getContentType();
        JacksonActionConfiguration jacksonConfiguration = (JacksonActionConfiguration)config.additionalConfiguration.get(JacksonActionConfiguration.class);
        if (!jacksonConfiguration.requestMembers.isEmpty()) {
            HTTPMethod httpMethod = actionInvocation.method.httpMethod;
            JacksonActionConfiguration.RequestMember requestMember = jacksonConfiguration.requestMembers.get(httpMethod);
            try {
                if (logger.isDebugEnabled()) {
                    String body = new String(this.request.getBodyBytes());
                    logger.debug("Request: ({} {}) {}", new Object[]{this.request.getMethod(), this.request.getPath(), body});
                    if (this.request.getInputStream() != null) {
                        Charset characterEncoding = ObjectTools.defaultIfNull(this.request.getCharacterEncoding(), StandardCharsets.UTF_8);
                        this.request.setInputStream((InputStream)new ByteArrayInputStream(body.getBytes(characterEncoding)));
                    }
                }
                Object currentValue = this.expressionEvaluator.getValue(requestMember.name, action);
                this.handle(action, currentValue, contentType, requestMember);
            }
            catch (InvalidFormatException e) {
                logger.debug("Error parsing JSON request", (Throwable)e);
                this.addFieldError(e);
                throw new ValidationException(e, new Object[0]);
            }
            catch (UnrecognizedPropertyException e) {
                logger.debug("Error parsing JSON request", (Throwable)e);
                String field = this.buildField((JsonMappingException)((Object)e));
                this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[invalidJSON]", this.messageProvider.getMessage("[invalidJSON]", field, "Unrecognized property", e.getMessage())));
                throw new ValidationException(e, new Object[0]);
            }
            catch (JsonMappingException e) {
                logger.debug("Error parsing JSON request", (Throwable)e);
                if (!(e.getCause() instanceof JsonParseException)) {
                    this.addFieldError(e);
                } else {
                    this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[invalidJSON]", this.messageProvider.getMessage("[invalidJSON]", "unknown", "Unexpected mapping exception", e.getMessage())));
                }
                throw new ValidationException(e, new Object[0]);
            }
            catch (JsonProcessingException e) {
                logger.debug("Error parsing JSON request", (Throwable)e);
                this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[invalidJSON]", this.messageProvider.getMessage("[invalidJSON]", "unknown", "Unexpected processing exception", e.getMessage())));
                throw new ValidationException(e, new Object[0]);
            }
            catch (JsonPatchException e) {
                if ("value differs from expectations".equals(e.getMessage())) {
                    this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[JSONPatchTestFailed]", this.messageProvider.getMessage("[JSONPatchTestFailed]", new Object[0])));
                } else {
                    logger.debug("Error parsing JSON Patch request", (Throwable)e);
                    this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[invalidJSON]", this.messageProvider.getMessage("[invalidJSON]", "unknown", "Unexpected processing exception", e.getMessage())));
                }
                throw new ValidationException(e, new Object[0]);
            }
        }
    }

    protected abstract void handle(Object var1, Object var2, String var3, JacksonActionConfiguration.RequestMember var4) throws IOException, JsonPatchException;

    private void addFieldError(JsonMappingException e) {
        String field = this.buildField(e);
        String code = "[invalidJSON]";
        if (field.equals("")) {
            this.messageStore.add(new SimpleMessage(MessageType.ERROR, code, this.messageProvider.getMessage(code, "unknown", "Possible conversion error", e.getMessage())));
        } else {
            this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, field, code, this.messageProvider.getMessage(code, field, "Possible conversion error", e.getMessage())));
        }
    }

    private void addFieldError(InvalidFormatException e) {
        String field = this.buildField((JsonMappingException)((Object)e));
        String code = "[invalidJSON]";
        if (field.equals("")) {
            this.messageStore.add(new SimpleMessage(MessageType.ERROR, code, this.messageProvider.getMessage(code, "unknown", "Possible conversion error", e.getMessage())));
        } else {
            String messageText = e.getMessage();
            Matcher matchesEnumNotValidValue = invalidEnumerationValue.matcher(messageText);
            String message = null;
            if (matchesEnumNotValidValue.matches() && matchesEnumNotValidValue.groupCount() == 2) {
                String customCode = "[invalidOption]%s".formatted(field);
                String possibleValues = matchesEnumNotValidValue.group(2);
                String valueUsed = matchesEnumNotValidValue.group(1);
                try {
                    message = this.messageProvider.getMessage(customCode, valueUsed, possibleValues);
                    code = customCode;
                }
                catch (MissingMessageException missingMessageException) {
                    // empty catch block
                }
            }
            if (message == null) {
                message = this.messageProvider.getMessage(code, field, "Possible conversion error", messageText);
            }
            this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, field, code, message));
        }
    }

    private String buildField(JsonMappingException e) {
        StringBuilder fieldBuilder = new StringBuilder();
        List references = e.getPath();
        for (JsonMappingException.Reference reference : references) {
            String fieldName = reference.getFieldName();
            if (fieldName == null) continue;
            if (fieldBuilder.length() > 0) {
                fieldBuilder.append(".");
            }
            fieldBuilder.append(fieldName);
        }
        return fieldBuilder.toString();
    }
}

