/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.action.result.annotation.XMLStream;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public class XMLStreamResult
extends AbstractResult<XMLStream> {
    private final ActionInvocationStore actionInvocationStore;
    private final HTTPResponse response;

    @Inject
    public XMLStreamResult(ExpressionEvaluator expressionEvaluator, HTTPResponse response, ActionInvocationStore actionInvocationStore) {
        super(expressionEvaluator);
        this.response = response;
        this.actionInvocationStore = actionInvocationStore;
    }

    @Override
    public boolean execute(XMLStream xmlStream) throws IOException {
        String xml = xmlStream.property();
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object object = this.expressionEvaluator.getValue(xml, actionInvocation.action);
        if (!(object instanceof String)) {
            throw new PrimeException("Invalid property [" + xml + "] for XMLStream result. This property returned null or an Object that is not a String.");
        }
        byte[] xmlBytes = ((String)object).getBytes(StandardCharsets.UTF_8);
        this.response.setStatus(xmlStream.status());
        this.response.setContentType("application/xhtml+xml; charset=UTF-8");
        this.response.setContentLength((long)xmlBytes.length);
        this.addCacheControlHeader(xmlStream, this.response);
        if (this.isHeadRequest(actionInvocation)) {
            return true;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(xmlBytes);
        ((InputStream)is).transferTo(this.response.getOutputStream());
        return true;
    }

    @Override
    protected String getCacheControl(XMLStream result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(XMLStream result) {
        return result.disableCacheControl();
    }
}

