/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.validation;

import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.validation.DefaultValidationWorkflow;
import org.primeframework.mvc.validation.ValidationException;
import org.primeframework.mvc.validation.ValidationProcessor;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultValidationWorkflowTest
extends PrimeBaseTest {
    @Test
    public void failureByExcception() throws Exception {
        ValidationProcessor validationProcessor = (ValidationProcessor)EasyMock.createStrictMock(ValidationProcessor.class);
        validationProcessor.validate();
        EasyMock.expectLastCall().andThrow((Throwable)new ValidationException());
        EasyMock.replay((Object[])new Object[]{validationProcessor});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        DefaultValidationWorkflow defaultValidationWorkflow = new DefaultValidationWorkflow(validationProcessor);
        try {
            defaultValidationWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have failed");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{validationProcessor, workflowChain});
    }

    @Test
    public void success() throws Exception {
        ValidationProcessor validationProcessor = (ValidationProcessor)EasyMock.createStrictMock(ValidationProcessor.class);
        validationProcessor.validate();
        EasyMock.replay((Object[])new Object[]{validationProcessor});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        DefaultValidationWorkflow defaultValidationWorkflow = new DefaultValidationWorkflow(validationProcessor);
        defaultValidationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{validationProcessor, workflowChain});
    }
}

