/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.cors;

import io.fusionauth.http.HTTPMethod;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.cors.CORSConfiguration;
import org.primeframework.mvc.test.RequestResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CORSFilterTest
extends PrimeBaseTest {
    @DataProvider(name="get_included_path_pattern")
    private static Object[][] getIncludeExcludes() {
        return new Object[][]{{"/foo", false}, {"/admin/foo", true}};
    }

    @Override
    @AfterMethod
    public void afterMethod() {
        super.afterMethod();
        corsConfiguration = null;
    }

    @Override
    @BeforeMethod
    public void beforeMethod() {
        super.beforeMethod();
        corsConfiguration = new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withExcludedPathPattern(Pattern.compile("^/account.*|^/admin.*|^/support.*|^/ajax.*|^/css/.*|^/fonts/.*|^/images/.*|^/js/.*")).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800);
    }

    @DataProvider(name="excludedURIs")
    public Object[][] excludedURIs() {
        return new Object[][]{{"/admin/foo"}, {"/admin/nested/foo"}, {"/ajax/foo"}};
    }

    @Test
    public void get() throws Exception {
        simulator.test("/api/status").withHeader("Origin", "https://jackinthebox.com").get().assertStatusCode(200).assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Expose-Headers", "Access-Control-Allow-Origin,Access-Control-Allow-Credentials").assertHeaderContains("Access-Control-Allow-Origin", "https://jackinthebox.com").assertHeaderContains("Vary", "Origin").assertHeaderDoesNotContain("Access-Control-Allow-Methods").assertHeaderDoesNotContain("Access-Control-Allow-Headers").assertHeaderDoesNotContain("Access-Control-Max-Age");
    }

    @Test
    public void get_reactNativeOrigin() throws Exception {
        simulator.test("/api/status").withHeader("Origin", "file://foo/index.html").get().assertStatusCode(200).assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Expose-Headers", "Access-Control-Allow-Origin,Access-Control-Allow-Credentials").assertHeaderContains("Access-Control-Allow-Origin", "file://foo/index.html").assertHeaderContains("Vary", "Origin").assertHeaderDoesNotContain("Access-Control-Allow-Methods").assertHeaderDoesNotContain("Access-Control-Allow-Headers").assertHeaderDoesNotContain("Access-Control-Max-Age");
        simulator.test("/api/status").withHeader("Origin", "file://").get().assertStatusCode(200).assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Expose-Headers", "Access-Control-Allow-Origin,Access-Control-Allow-Credentials").assertHeaderContains("Access-Control-Allow-Origin", "file://").assertHeaderContains("Vary", "Origin").assertHeaderDoesNotContain("Access-Control-Allow-Methods").assertHeaderDoesNotContain("Access-Control-Allow-Headers").assertHeaderDoesNotContain("Access-Control-Max-Age");
    }

    @Test
    public void get_sameOrigin() throws Exception {
        CORSFilterTest.corsConfiguration.allowedOrigins.clear();
        RequestResult requestResult = simulator.test("/api/status").withHeader("Origin", "http://localhost:9080").get().assertStatusCode(200);
        this.assertNoCORSHeaders(requestResult);
        corsConfiguration.withAllowedOrigins(new URI[]{URI.create("http://jackinthebox.com")}).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET});
        requestResult = simulator.test("/api/status").withHeader("Content-Type", "application/json").withHeader("Origin", "http://jackinthebox.com").post().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void get_validateDisallowedMethod() throws Exception {
        corsConfiguration.withAllowedMethods(new HTTPMethod[]{HTTPMethod.POST}).withAllowedOrigins(new URI[]{URI.create("*")});
        this.assertUnauthorized();
    }

    @Test
    public void get_validateDisallowedOrigin() throws Exception {
        corsConfiguration.withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET}).withAllowedOrigins(new URI[]{URI.create("http://foo.com"), URI.create("https://bar.com")});
        this.assertUnauthorized();
    }

    @Test(dataProvider="excludedURIs")
    public void get_validateExcludedURIs(String string) throws Exception {
        RequestResult requestResult = simulator.test(string).get().assertStatusCode(200);
        this.assertNoCORSHeaders(requestResult);
        requestResult = simulator.test(string).withHeader("Origin", "http://foo.com").get().assertStatusCode(200);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void included_and_excluded_uri_checker_supplied() {
        IllegalStateException illegalStateException = (IllegalStateException)Assert.expectThrows(IllegalStateException.class, () -> new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withIncludeURIPredicate(string -> true).withExcludeURIPredicate(string -> true).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800));
        Assert.assertEquals((String)illegalStateException.getMessage(), (String)"You cannot use both withIncludeURIPredicate and withExcludeURIPredicate. You must use one or the other.");
    }

    @Test
    public void included_path_and_excluded_path_supplied() {
        IllegalStateException illegalStateException = (IllegalStateException)Assert.expectThrows(IllegalStateException.class, () -> new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withExcludedPathPattern(Pattern.compile("does not matter")).withIncludedPathPattern(Pattern.compile("does not matter")).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800));
        Assert.assertEquals((String)illegalStateException.getMessage(), (String)"You cannot use both withExcludedPathPattern and withIncludedPathPattern. You must use one or the other.");
    }

    @Test
    public void options() throws Exception {
        simulator.test("/api/status").withHeader("Access-Control-Request-Method", "POST").withHeader("Access-Control-Request-Headers", "X-FusionAuth-TenantId").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(204).assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Allow-Headers", "Accept,Access-Control-Request-Headers,Access-Control-Request-Method,Authorization,Content-Type,Last-Modified,Origin,X-FusionAuth-TenantId,X-Requested-With").assertHeaderContains("Access-Control-Allow-Methods", "POST").assertHeaderContains("Access-Control-Max-Age", "1800").assertHeaderContains("Access-Control-Allow-Origin", "https://jackinthebox.com").assertHeaderDoesNotContain("Access-Control-Expose-Headers").assertHeaderContains("Vary", "Origin");
    }

    @Test(dataProvider="get_included_path_pattern")
    public void options_excluded_uri_checker(String string2, boolean bl) throws Exception {
        corsConfiguration = new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withExcludeURIPredicate(string -> string.startsWith("/foo")).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800);
        simulator.test(string2).withHeader("Access-Control-Request-Method", "GET").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(bl ? 204 : 403);
    }

    @Test(dataProvider="get_included_path_pattern")
    public void options_included_path_pattern(String string, boolean bl) throws Exception {
        corsConfiguration = new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withIncludedPathPattern(Pattern.compile("^/admin/foo")).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800);
        RequestResult requestResult = simulator.test(string).withHeader("Access-Control-Request-Method", "GET").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(bl ? 204 : 403);
        if (!bl) {
            return;
        }
        requestResult.assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Allow-Headers", "Accept,Access-Control-Request-Headers,Access-Control-Request-Method,Authorization,Content-Type,Last-Modified,Origin,X-FusionAuth-TenantId,X-Requested-With").assertHeaderContains("Access-Control-Allow-Methods", "GET").assertHeaderContains("Access-Control-Max-Age", "1800").assertHeaderContains("Access-Control-Allow-Origin", "https://jackinthebox.com").assertHeaderDoesNotContain("Access-Control-Expose-Headers").assertHeaderContains("Vary", "Origin");
    }

    @Test(dataProvider="get_included_path_pattern")
    public void options_included_uri_checker(String string2, boolean bl) throws Exception {
        corsConfiguration = new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withIncludeURIPredicate(string -> string.startsWith("/admin/foo")).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800);
        RequestResult requestResult = simulator.test(string2).withHeader("Access-Control-Request-Method", "GET").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(bl ? 204 : 403);
        if (!bl) {
            return;
        }
        requestResult.assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Allow-Headers", "Accept,Access-Control-Request-Headers,Access-Control-Request-Method,Authorization,Content-Type,Last-Modified,Origin,X-FusionAuth-TenantId,X-Requested-With").assertHeaderContains("Access-Control-Allow-Methods", "GET").assertHeaderContains("Access-Control-Max-Age", "1800").assertHeaderContains("Access-Control-Allow-Origin", "https://jackinthebox.com").assertHeaderDoesNotContain("Access-Control-Expose-Headers").assertHeaderContains("Vary", "Origin");
    }

    @Test
    public void options_validateDisallowedHeader() throws Exception {
        RequestResult requestResult = simulator.test("/api/status").withHeader("Access-Control-Request-Method", "GET").withHeader("Access-Control-Request-Headers", "X-Foo").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void options_validateDisallowedMethod() throws Exception {
        corsConfiguration.withAllowedMethods(new HTTPMethod[]{HTTPMethod.POST});
        RequestResult requestResult = simulator.test("/api/status").withHeader("Access-Control-Request-Method", "GET").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void options_validateDisallowedOrigin() throws Exception {
        corsConfiguration.withAllowedOrigins(new URI[]{URI.create("http://foo.com")});
        RequestResult requestResult = simulator.test("/api/status").withHeader("Access-Control-Request-Method", "GET").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void options_validateExcludedURIs() throws Exception {
        RequestResult requestResult = simulator.test("/admin/foo").withHeader("Origin", "http://foo.com").options().assertStatusCode(405);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void options_validateWildcardOriginDisallowCredentials() throws Exception {
        corsConfiguration.withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET}).withAllowedOrigins(new URI[]{URI.create("*")}).withAllowCredentials(false);
        simulator.test("/api/status").withHeader("Access-Control-Request-Method", "GET").withHeader("Origin", "https://jackinthebox.com").options().assertStatusCode(204).assertHeaderDoesNotContain("Access-Control-Allow-Credentials").assertHeaderContains("Access-Control-Allow-Origin", "*").assertHeaderContains("Access-Control-Allow-Headers", "Accept,Access-Control-Request-Headers,Access-Control-Request-Method,Authorization,Content-Type,Last-Modified,Origin,X-FusionAuth-TenantId,X-Requested-With").assertHeaderContains("Access-Control-Allow-Methods", "GET").assertHeaderDoesNotContain("Access-Control-Expose-Headers").assertHeaderContains("Access-Control-Max-Age", "1800");
    }

    @Test
    public void path_and_checker_supplied() {
        IllegalStateException illegalStateException = (IllegalStateException)Assert.expectThrows(IllegalStateException.class, () -> new CORSConfiguration().withAllowCredentials(true).withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET, HTTPMethod.POST, HTTPMethod.HEAD, HTTPMethod.OPTIONS, HTTPMethod.PUT, HTTPMethod.DELETE}).withAllowedHeaders(new String[]{"Accept", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Authorization", "Content-Type", "Last-Modified", "Origin", "X-FusionAuth-TenantId", "X-Requested-With"}).withAllowedOrigins(new URI[]{URI.create("*")}).withExcludedPathPattern(Pattern.compile("does not matter")).withExcludeURIPredicate(string -> true).withExposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).withPreflightMaxAgeInSeconds(1800));
        Assert.assertEquals((String)illegalStateException.getMessage(), (String)"You cannot use both a path (withIncludedPathPattern/withExcludedPathPattern) and predicate based (withIncludeURIPredicate/withExcludeURIPredicate). You must use one or the other.");
    }

    @Test
    public void post() throws Exception {
        simulator.test("/api/status").withHeader("Content-Type", "application/json").withHeader("Origin", "https://jackinthebox.com").post().assertStatusCode(200).assertHeaderContains("Access-Control-Allow-Credentials", "true").assertHeaderContains("Access-Control-Allow-Origin", "https://jackinthebox.com").assertHeaderDoesNotContain("Access-Control-Allow-Headers").assertHeaderDoesNotContain("Access-Control-Allow-Methods").assertHeaderContains("Access-Control-Expose-Headers", "Access-Control-Allow-Origin,Access-Control-Allow-Credentials").assertBodyDoesNotContain("Access-Control-Max-Age");
        RequestResult requestResult = simulator.test("/api/status").withHeader("Origin", "https://jackinthebox.com").post().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void post_validateDisallowedMethod() throws Exception {
        corsConfiguration.withAllowedMethods(new HTTPMethod[]{HTTPMethod.GET});
        RequestResult requestResult = simulator.test("/api/status").withHeader("Origin", "https://jackinthebox.com").post().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void post_validateDisallowedOrigin() throws Exception {
        corsConfiguration.withAllowedOrigins(new URI[]{URI.create("http://foo.com")});
        RequestResult requestResult = simulator.test("/api/status").withHeader("Origin", "https://jackinthebox.com").post().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }

    @Test
    public void post_validateExcludedURIs_withSimpleContentType() throws Exception {
        RequestResult requestResult = simulator.test("/admin/nested/foo").post().assertStatusCode(200);
        this.assertNoCORSHeaders(requestResult);
        requestResult = simulator.test("/admin/nested/foo").withHeader("Origin", "https://jackinthebox.com").post().assertStatusCode(200);
        this.assertNoCORSHeaders(requestResult);
    }

    private void assertNoCORSHeaders(RequestResult requestResult) {
        requestResult.assertHeaderDoesNotContain("Access-Control-Allow-Credentials").assertHeaderDoesNotContain("Access-Control-Allow-Headers").assertHeaderDoesNotContain("Access-Control-Allow-Methods").assertHeaderDoesNotContain("Access-Control-Allow-Origin").assertHeaderDoesNotContain("Access-Control-Expose-Headers").assertHeaderDoesNotContain("Access-Control-Max-Age").assertHeaderDoesNotContain("Vary");
    }

    private void assertUnauthorized() throws IOException, InterruptedException {
        RequestResult requestResult = simulator.test("/api/status").withHeader("Origin", "https://jackinthebox.com").get().assertStatusCode(403);
        this.assertNoCORSHeaders(requestResult);
    }
}

