/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.time.ZonedDateTime;
import org.example.action.user.EditAction;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.YearSelect;
import org.testng.annotations.Test;

public class YearSelectTest
extends ControlBaseTest {
    @Inject
    public YearSelect yearSelect;

    @Test
    public void action() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setYear(2003);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/years-select", null, null));
        new ControlBaseTest.ControlTester((Control)this.yearSelect).attr("name", "user.year").attr("startYear", 2001).attr("endYear", 2006).go("<input type=\"hidden\" name=\"user.year@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"user_year\" class=\"label\">Year</label></div>\n<div class=\"control-container\">\n<select id=\"user_year\" name=\"user.year\">\n<option value=\"2001\">2001</option>\n<option value=\"2002\">2002</option>\n<option value=\"2003\" selected=\"selected\">2003</option>\n<option value=\"2004\">2004</option>\n<option value=\"2005\">2005</option>\n<option value=\"2006\">2006</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void actionLess() {
        int n = ZonedDateTime.now().getYear();
        this.ais.setCurrent(new ActionInvocation(null, null, "/years-select", null, null));
        new ControlBaseTest.ControlTester((Control)this.yearSelect).attr("name", "test").attr("class", "css-class").go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-select css-class-input css-class-control select input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\">\n<select class=\"css-class\" id=\"test\" name=\"test\">\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n++ + "</option>\n<option value=\"" + n + "\">" + n + "</option>\n</select>\n</div>\n</div>\n");
    }
}

