/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import java.nio.file.Path;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.primeframework.mvc.config.AbstractMVCConfiguration;

public class MockConfiguration
extends AbstractMVCConfiguration {
    public boolean allowUnknownParameters;
    public boolean autoHTMLEscapingEnabled = true;
    public Key cookieEncryptionKey;
    public boolean csrfEnabled;
    public int freemarkerCheckSeconds;
    public int l10nReloadSeconds;

    public MockConfiguration() {
        this.regenerateCookieEncryptionKey();
    }

    public MockConfiguration(int n, int n2, boolean bl, boolean bl2) {
        this();
        this.freemarkerCheckSeconds = n;
        this.l10nReloadSeconds = n2;
        this.allowUnknownParameters = bl;
        this.csrfEnabled = bl2;
    }

    public boolean allowUnknownParameters() {
        return this.allowUnknownParameters;
    }

    public boolean autoHTMLEscapingEnabled() {
        return this.autoHTMLEscapingEnabled;
    }

    public Path baseDirectory() {
        return Path.of("src/test/web", new String[0]);
    }

    public Key cookieEncryptionKey() {
        return this.cookieEncryptionKey;
    }

    public boolean csrfEnabled() {
        return this.csrfEnabled;
    }

    public int l10nReloadSeconds() {
        return this.l10nReloadSeconds;
    }

    public String localeCookieName() {
        return this.localeCookieName;
    }

    public MockConfiguration regenerateCookieEncryptionKey() {
        byte[] byArray = new byte[16];
        new SecureRandom().nextBytes(byArray);
        this.cookieEncryptionKey = new SecretKeySpec(byArray, "AES");
        return this;
    }

    public int templateCheckSeconds() {
        return this.freemarkerCheckSeconds;
    }
}

