/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.primeframework.mvc.test.BodyTools;
import org.primeframework.mvc.test.DetectionMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BodyToolsTest {
    @Test
    public void processTemplateWithMap_all_variables_used() throws Exception {
        DetectionMap detectionMap = new DetectionMap();
        detectionMap.put("message", "howdy");
        String string = BodyTools.processTemplateWithMap(Paths.get("src/test/web/templates/echo.ftl", new String[0]), detectionMap);
        Assert.assertEquals((String)string, (String)"howdy");
    }

    @Test
    public void processTemplateWithMap_functions() throws Exception {
        DetectionMap detectionMap = new DetectionMap();
        detectionMap.putAll(Map.of("_to_milli", "howdy", "actual", "someactualthing"));
        String string = BodyTools.processTemplateWithMap(Paths.get("src/test/web/templates/echo.ftl", new String[0]), detectionMap);
        Assert.assertEquals((String)string, (String)"missing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void processTemplateWithMap_new_file() throws Exception {
        Path path = Paths.get("src/test/web/templates/new_file.ftl", new String[0]);
        try {
            DetectionMap detectionMap = new DetectionMap();
            detectionMap.putAll(Map.of("message", "howdy", "othervariable", "value"));
            String string = BodyTools.processTemplateWithMap(path, detectionMap);
            Assert.assertEquals((String)string, (String)"{\"prime-mvc-auto-generated\": true}");
        }
        finally {
            if (path.toFile().exists()) {
                path.toFile().delete();
            }
        }
    }

    @Test
    public void processTemplateWithMap_optional_variable_unused() throws Exception {
        DetectionMap detectionMap = new DetectionMap();
        detectionMap.putAll(Map.of("message", "howdy", "othervariable", Optional.of("value")));
        String string = BodyTools.processTemplateWithMap(Paths.get("src/test/web/templates/echo.ftl", new String[0]), detectionMap);
        Assert.assertEquals((String)string, (String)"howdy");
    }

    @Test
    public void processTemplateWithMap_optional_variable_used() throws Exception {
        DetectionMap detectionMap = new DetectionMap();
        detectionMap.put("message", Optional.of("howdy"));
        String string = BodyTools.processTemplateWithMap(Paths.get("src/test/web/templates/echo.ftl", new String[0]), detectionMap);
        Assert.assertEquals((String)string, (String)"howdy");
    }

    @Test
    public void processTemplateWithMap_unused_variables() throws Exception {
        DetectionMap detectionMap = new DetectionMap();
        detectionMap.putAll(Map.of("message", "howdy", "othervariable", "value"));
        try {
            BodyTools.processTemplateWithMap(Paths.get("src/test/web/templates/echo.ftl", new String[0]), detectionMap);
            Assert.fail((String)"Expected an exception");
        }
        catch (Exception exception) {
            Assert.assertEquals(exception.getClass(), IllegalArgumentException.class, (String)"Expected this exception type");
            Assert.assertEquals((String)exception.getMessage(), (String)"Unused values [othervariable] found in the [src/test/web/templates/echo.ftl] template. If it's acceptable for the variable to be unused, wrap it in an Optional", (String)"othervariable is in the map but is not used");
        }
    }
}

