/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message.scope;

import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.scope.RequestScope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RequestScopeTest {
    @Test
    public void add() {
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getAttribute("primeMessages")).andReturn(arrayList);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        RequestScope requestScope = new RequestScope(hTTPRequest);
        requestScope.add((Message)new SimpleMessage(MessageType.ERROR, "code", "Foo"));
        Assert.assertEquals((int)arrayList.size(), (int)1);
        Assert.assertEquals((String)((Message)arrayList.get(0)).toString(), (String)"Foo");
        EasyMock.verify((Object[])new Object[]{hTTPRequest});
    }

    @Test
    public void addAll() {
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getAttribute("primeMessages")).andReturn(arrayList);
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        RequestScope requestScope = new RequestScope(hTTPRequest);
        requestScope.addAll(List.of(new SimpleMessage(MessageType.ERROR, "code1", "Foo"), new SimpleMessage(MessageType.ERROR, "code2", "Bar")));
        Assert.assertEquals((int)arrayList.size(), (int)2);
        Assert.assertEquals((String)((Message)arrayList.get(0)).toString(), (String)"Foo");
        Assert.assertEquals((String)((Message)arrayList.get(1)).toString(), (String)"Bar");
        EasyMock.verify((Object[])new Object[]{hTTPRequest});
    }

    @Test
    public void get() {
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        EasyMock.expect((Object)hTTPRequest.getAttribute("primeMessages")).andReturn(List.of(new SimpleMessage(MessageType.ERROR, "code", "Test message")));
        EasyMock.replay((Object[])new Object[]{hTTPRequest});
        RequestScope requestScope = new RequestScope(hTTPRequest);
        List list = requestScope.get();
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertEquals((String)((Message)list.get(0)).toString(), (String)"Test message");
        EasyMock.verify((Object[])new Object[]{hTTPRequest});
    }
}

