/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.ReexecuteSavedRequestResult;
import org.primeframework.mvc.action.result.SavedRequestTools;
import org.primeframework.mvc.action.result.annotation.ReexecuteSavedRequest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.GCMCipherProvider;
import org.primeframework.mvc.security.saved.SavedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReexecuteSavedRequestResultTest
extends PrimeBaseTest {
    @Test
    public void noSavedRequest() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        ReexecuteSavedRequestResult.ReexecuteSavedRequestImpl reexecuteSavedRequestImpl = new ReexecuteSavedRequestResult.ReexecuteSavedRequestImpl("/", "success", true, false);
        ReexecuteSavedRequestResult reexecuteSavedRequestResult = new ReexecuteSavedRequestResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore, (MVCConfiguration)configuration, (Encryptor)new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration)), this.objectMapper);
        reexecuteSavedRequestResult.execute((ReexecuteSavedRequest)reexecuteSavedRequestImpl);
        EasyMock.verify((Object[])new Object[]{expressionEvaluator, actionInvocationStore, messageStore});
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)301);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void savedRequest() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        SavedHttpRequest savedHttpRequest = new SavedHttpRequest(HTTPMethod.GET, "/secure?test=value1&test2=value2", null);
        ReexecuteSavedRequestResultTest.simulator.userAgent.addCookie(SavedRequestTools.toCookie((SavedHttpRequest)savedHttpRequest, (MVCConfiguration)configuration, (Encryptor)new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration)), (ObjectMapper)this.objectMapper));
        ArrayList arrayList = new ArrayList();
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration));
        Cookie cookie = SavedRequestTools.toCookie((SavedHttpRequest)savedHttpRequest, (MVCConfiguration)configuration, (Encryptor)defaultEncryptor, (ObjectMapper)this.objectMapper);
        HTTPRequest hTTPRequest2 = (HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.addCookies(new Cookie[]{cookie}));
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        ReexecuteSavedRequestResult.ReexecuteSavedRequestImpl reexecuteSavedRequestImpl = new ReexecuteSavedRequestResult.ReexecuteSavedRequestImpl("/", "success", true, false);
        ReexecuteSavedRequestResult reexecuteSavedRequestResult = new ReexecuteSavedRequestResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest2, actionInvocationStore, (MVCConfiguration)configuration, (Encryptor)new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration)), this.objectMapper);
        reexecuteSavedRequestResult.execute((ReexecuteSavedRequest)reexecuteSavedRequestImpl);
        EasyMock.verify((Object[])new Object[]{expressionEvaluator, actionInvocationStore, messageStore});
        Assert.assertEquals((int)hTTPResponse.getCookies().size(), (int)1);
        Assert.assertEquals((String)((Cookie)hTTPResponse.getCookies().getFirst()).name, (String)ReexecuteSavedRequestResultTest.configuration.savedRequestCookieName);
        Assert.assertEquals((long)((Cookie)hTTPResponse.getCookies().getFirst()).maxAge, (long)0L);
        Assert.assertFalse((boolean)((Cookie)hTTPResponse.getCookies().getFirst()).value.startsWith("ready_"));
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)301);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/secure?test=value1&test2=value2");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }
}

