/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker;

import java.io.File;
import java.io.IOException;
import org.easymock.EasyMock;
import org.primeframework.mvc.container.ContainerResolver;
import org.primeframework.mvc.freemarker.OverridingTemplateLoader;
import org.primeframework.mvc.freemarker.URLTemplateSource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OverridingTemplateLoaderTest {
    @Test
    public void classPath() throws IOException {
        ContainerResolver containerResolver = (ContainerResolver)EasyMock.createStrictMock(ContainerResolver.class);
        EasyMock.expect((Object)containerResolver.getRealPath("logging.properties")).andReturn((Object)"build/classes/test/logging.properties");
        EasyMock.replay((Object[])new Object[]{containerResolver});
        OverridingTemplateLoader overridingTemplateLoader = new OverridingTemplateLoader(containerResolver);
        URLTemplateSource uRLTemplateSource = (URLTemplateSource)overridingTemplateLoader.findTemplateSource("logging.properties");
        File file = new File("src/test/resources/logging.properties");
        Assert.assertTrue((overridingTemplateLoader.getLastModified((Object)uRLTemplateSource) > file.lastModified() ? 1 : 0) != 0);
        Assert.assertEquals((long)overridingTemplateLoader.getLastModified((Object)uRLTemplateSource), (long)overridingTemplateLoader.getLastModified((Object)uRLTemplateSource));
        Assert.assertNotNull((Object)overridingTemplateLoader.getReader((Object)uRLTemplateSource, "UTF-8"));
        overridingTemplateLoader.closeTemplateSource((Object)uRLTemplateSource);
        EasyMock.verify((Object[])new Object[]{containerResolver});
    }

    @Test
    public void realPath() throws IOException {
        ContainerResolver containerResolver = (ContainerResolver)EasyMock.createStrictMock(ContainerResolver.class);
        EasyMock.expect((Object)containerResolver.getRealPath("build.savant")).andReturn((Object)"build.savant");
        EasyMock.replay((Object[])new Object[]{containerResolver});
        OverridingTemplateLoader overridingTemplateLoader = new OverridingTemplateLoader(containerResolver);
        URLTemplateSource uRLTemplateSource = (URLTemplateSource)overridingTemplateLoader.findTemplateSource("build.savant");
        File file = new File("build.savant");
        Assert.assertEquals((long)overridingTemplateLoader.getLastModified((Object)uRLTemplateSource), (long)file.lastModified());
        Assert.assertNotNull((Object)overridingTemplateLoader.getReader((Object)uRLTemplateSource, "UTF-8"));
        overridingTemplateLoader.closeTemplateSource((Object)uRLTemplateSource);
        EasyMock.verify((Object[])new Object[]{containerResolver});
    }

    @Test
    public void resource() throws IOException {
        ContainerResolver containerResolver = (ContainerResolver)EasyMock.createStrictMock(ContainerResolver.class);
        EasyMock.expect((Object)containerResolver.getRealPath("build.savant")).andReturn(null);
        EasyMock.expect((Object)containerResolver.getResource("build.savant")).andReturn((Object)new File("build.savant").toURI().toURL());
        EasyMock.replay((Object[])new Object[]{containerResolver});
        OverridingTemplateLoader overridingTemplateLoader = new OverridingTemplateLoader(containerResolver);
        URLTemplateSource uRLTemplateSource = (URLTemplateSource)overridingTemplateLoader.findTemplateSource("build.savant");
        File file = new File("build.savant");
        Assert.assertEquals((long)overridingTemplateLoader.getLastModified((Object)uRLTemplateSource), (long)file.lastModified());
        Assert.assertNotNull((Object)overridingTemplateLoader.getReader((Object)uRLTemplateSource, "UTF-8"));
        overridingTemplateLoader.closeTemplateSource((Object)uRLTemplateSource);
        EasyMock.verify((Object[])new Object[]{containerResolver});
    }
}

