/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.config;

import io.fusionauth.http.HTTPMethod;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.example.action.KitchenSinkAction;
import org.example.action.SimpleAction;
import org.example.action.TestAnnotation;
import org.example.action.nested.FooAction;
import org.example.action.nested.FooReduxAction;
import org.example.action.nested.IndexAction;
import org.example.action.nested.ParameterAction;
import org.example.action.nested.treeCollisions.SecondAction;
import org.example.domain.UserField;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.ValidationMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfigurationBuilder;
import org.primeframework.mvc.action.config.ActionConfigurator;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.action.config.DefaultActionConfigurationProvider;
import org.primeframework.mvc.action.result.annotation.Forward;
import org.primeframework.mvc.action.result.annotation.JSON;
import org.primeframework.mvc.action.result.annotation.Redirect;
import org.primeframework.mvc.action.result.annotation.Status;
import org.primeframework.mvc.content.binary.BinaryActionConfiguration;
import org.primeframework.mvc.content.binary.BinaryActionConfigurator;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.content.json.JacksonActionConfigurator;
import org.primeframework.mvc.util.DefaultURIBuilder;
import org.primeframework.mvc.util.URIBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultActionConfigurationProviderTest {
    @Test
    public void configure() throws Exception {
        DefaultActionConfigurationProvider defaultActionConfigurationProvider = new DefaultActionConfigurationProvider((ActionConfigurationBuilder)new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))));
        ActionInvocation actionInvocation = defaultActionConfigurationProvider.lookup("/simple");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, SimpleAction.class);
        Assert.assertNotNull((Object)actionInvocation.configuration.annotation);
        Assert.assertEquals((int)actionInvocation.configuration.executeMethods.size(), (int)9);
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.GET)).method, (Object)SimpleAction.class.getMethod("execute", new Class[0]));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.POST)).method, (Object)SimpleAction.class.getMethod("execute", new Class[0]));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.PUT)).method, (Object)SimpleAction.class.getMethod("execute", new Class[0]));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.HEAD)).method, (Object)SimpleAction.class.getMethod("execute", new Class[0]));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.DELETE)).method, (Object)SimpleAction.class.getMethod("execute", new Class[0]));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.PATCH)).method, (Object)SimpleAction.class.getMethod("execute", new Class[0]));
        Assert.assertEquals((int)actionInvocation.configuration.resultConfigurations.size(), (int)0);
        Assert.assertEquals((String)actionInvocation.configuration.pattern, (String)"");
        Assert.assertEquals((int)actionInvocation.configuration.patternParts.length, (int)0);
        Assert.assertEquals((String)actionInvocation.configuration.uri, (String)"/simple");
        Assert.assertEquals((int)actionInvocation.configuration.validationMethods.size(), (int)0);
        actionInvocation = defaultActionConfigurationProvider.lookup("/simple.rss");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, SimpleAction.class);
        Assert.assertEquals((String)actionInvocation.configuration.uri, (String)"/simple");
        Assert.assertEquals((String)actionInvocation.extension, (String)"rss");
        actionInvocation = defaultActionConfigurationProvider.lookup("/simple.htm");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, SimpleAction.class);
        Assert.assertEquals((String)actionInvocation.configuration.uri, (String)"/simple");
        Assert.assertEquals((String)actionInvocation.extension, (String)"htm");
        actionInvocation = defaultActionConfigurationProvider.lookup("/user/index");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, org.example.action.user.IndexAction.class);
        Assert.assertEquals((String)actionInvocation.configuration.uri, (String)"/user/index");
        actionInvocation = defaultActionConfigurationProvider.lookup("/user/index.xml");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, org.example.action.user.IndexAction.class);
        Assert.assertEquals((String)actionInvocation.configuration.uri, (String)"/user/index");
        Assert.assertEquals((String)actionInvocation.extension, (String)"xml");
        actionInvocation = defaultActionConfigurationProvider.lookup("/kitchen-sink");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, KitchenSinkAction.class);
        Assert.assertNotNull((Object)actionInvocation.configuration.annotation);
        Assert.assertNotNull(actionInvocation.configuration.annotations.get(TestAnnotation.class));
        Assert.assertEquals((int)actionInvocation.configuration.executeMethods.size(), (int)3);
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.GET)).method, (Object)KitchenSinkAction.class.getMethod("get", new Class[0]));
        Assert.assertNotNull(((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.GET)).annotations.get(TestAnnotation.class));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.HEAD)).method, (Object)KitchenSinkAction.class.getMethod("get", new Class[0]));
        Assert.assertEquals((Object)((ExecuteMethodConfiguration)actionInvocation.configuration.executeMethods.get((Object)HTTPMethod.POST)).method, (Object)KitchenSinkAction.class.getMethod("post", new Class[0]));
        Assert.assertNull(actionInvocation.configuration.executeMethods.get(HTTPMethod.PUT));
        Assert.assertNull(actionInvocation.configuration.executeMethods.get(HTTPMethod.DELETE));
        Assert.assertEquals((int)actionInvocation.configuration.resultConfigurations.size(), (int)8);
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward1")).code(), (String)"forward1");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward1")).contentType(), (String)"text");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward1")).page(), (String)"/WEB-INF/forward1.ftl");
        Assert.assertEquals((int)((Forward)actionInvocation.configuration.resultConfigurations.get("forward1")).status(), (int)200);
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward1")).statusStr(), (String)"");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward2")).code(), (String)"forward2");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward2")).contentType(), (String)"bin");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward2")).page(), (String)"/WEB-INF/forward2.ftl");
        Assert.assertEquals((int)((Forward)actionInvocation.configuration.resultConfigurations.get("forward2")).status(), (int)300);
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward2")).statusStr(), (String)"foo");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward-superclass")).code(), (String)"forward-superclass");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward-superclass")).contentType(), (String)"text/html; charset=UTF-8");
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward-superclass")).page(), (String)"forward-superclass.ftl");
        Assert.assertEquals((int)((Forward)actionInvocation.configuration.resultConfigurations.get("forward-superclass")).status(), (int)200);
        Assert.assertEquals((String)((Forward)actionInvocation.configuration.resultConfigurations.get("forward-superclass")).statusStr(), (String)"");
        Assert.assertEquals((String)((Redirect)actionInvocation.configuration.resultConfigurations.get("redirect1")).code(), (String)"redirect1");
        Assert.assertEquals((String)((Redirect)actionInvocation.configuration.resultConfigurations.get("redirect1")).uri(), (String)"/redirect1");
        Assert.assertTrue((boolean)((Redirect)actionInvocation.configuration.resultConfigurations.get("redirect1")).perm());
        Assert.assertEquals((String)((Redirect)actionInvocation.configuration.resultConfigurations.get("redirect2")).code(), (String)"redirect2");
        Assert.assertEquals((String)((Redirect)actionInvocation.configuration.resultConfigurations.get("redirect2")).uri(), (String)"/redirect2");
        Assert.assertFalse((boolean)((Redirect)actionInvocation.configuration.resultConfigurations.get("redirect2")).perm());
        Assert.assertEquals((String)((Status)actionInvocation.configuration.resultConfigurations.get("status")).code(), (String)"status");
        Assert.assertEquals((int)((Status)actionInvocation.configuration.resultConfigurations.get("status")).status(), (int)300);
        Assert.assertEquals((String)((Status)actionInvocation.configuration.resultConfigurations.get("status")).statusStr(), (String)"hello world");
        Assert.assertEquals((String)((Status)actionInvocation.configuration.resultConfigurations.get("status")).headers()[0].name(), (String)"foo");
        Assert.assertEquals((String)((Status)actionInvocation.configuration.resultConfigurations.get("status")).headers()[0].value(), (String)"bar");
        Assert.assertEquals((String)((Status)actionInvocation.configuration.resultConfigurations.get("status")).headers()[1].name(), (String)"baz");
        Assert.assertEquals((String)((Status)actionInvocation.configuration.resultConfigurations.get("status")).headers()[1].value(), (String)"fred");
        Assert.assertEquals((String)((JSON)actionInvocation.configuration.resultConfigurations.get("json")).code(), (String)"json");
        Assert.assertEquals((int)((JSON)actionInvocation.configuration.resultConfigurations.get("json")).status(), (int)201);
        Assert.assertEquals((String)actionInvocation.configuration.pattern, (String)"{name}/{value}/static/{foo}");
        Assert.assertEquals((int)actionInvocation.configuration.patternParts.length, (int)4);
        Assert.assertEquals((String)actionInvocation.configuration.uri, (String)"/kitchen-sink");
        Assert.assertEquals((int)actionInvocation.configuration.preParameterMethods.size(), (int)9);
        Assert.assertEquals((int)actionInvocation.configuration.postParameterMethods.size(), (int)1);
        Assert.assertEquals((int)actionInvocation.configuration.preValidationMethods.size(), (int)1);
        Assert.assertEquals((int)actionInvocation.configuration.postValidationMethods.size(), (int)1);
        Assert.assertEquals((int)actionInvocation.configuration.validationMethods.size(), (int)1);
        Assert.assertEquals((Object)((ValidationMethodConfiguration)((List)actionInvocation.configuration.validationMethods.get((Object)HTTPMethod.POST)).get((int)0)).method, (Object)KitchenSinkAction.class.getMethod("validate", new Class[0]));
        JacksonActionConfiguration jacksonActionConfiguration = (JacksonActionConfiguration)actionInvocation.configuration.additionalConfiguration.get(JacksonActionConfiguration.class);
        Assert.assertTrue((boolean)jacksonActionConfiguration.requestMembers.containsKey(HTTPMethod.POST));
        Assert.assertEquals((String)((JacksonActionConfiguration.RequestMember)jacksonActionConfiguration.requestMembers.get((Object)HTTPMethod.POST)).name, (String)"jsonRequest");
        Assert.assertEquals((Object)((JacksonActionConfiguration.RequestMember)jacksonActionConfiguration.requestMembers.get((Object)HTTPMethod.POST)).type, UserField.class);
        Assert.assertEquals((String)jacksonActionConfiguration.responseMember.name, (String)"jsonResponse");
        Assert.assertEquals((String)((BinaryActionConfiguration)actionInvocation.configuration.additionalConfiguration.get(BinaryActionConfiguration.class)).responseMember, (String)"binaryResponse");
        Assert.assertEquals((String)((BinaryActionConfiguration)actionInvocation.configuration.additionalConfiguration.get(BinaryActionConfiguration.class)).requestMember, (String)"binaryRequest");
        actionInvocation = defaultActionConfigurationProvider.lookup("/extension-inheritance");
        Assert.assertSame(((Annotation)actionInvocation.configuration.resultConfigurations.get("success")).annotationType(), Forward.class);
    }

    @Test
    public void index() {
        DefaultActionConfigurationProvider defaultActionConfigurationProvider = new DefaultActionConfigurationProvider((ActionConfigurationBuilder)new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))));
        ActionInvocation actionInvocation = defaultActionConfigurationProvider.lookup("/nested/one/two/index");
        Assert.assertEquals((Object)actionInvocation.configuration.actionClass, IndexAction.class);
        Assert.assertEquals((int)actionInvocation.uriParameters.size(), (int)2);
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("param1")), Collections.singletonList("one"));
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("param2")), Collections.singletonList("two"));
    }

    @Test
    public void lookupMultipleTreePaths() {
        DefaultActionConfigurationProvider defaultActionConfigurationProvider = new DefaultActionConfigurationProvider((ActionConfigurationBuilder)new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))));
        ActionInvocation actionInvocation = defaultActionConfigurationProvider.lookup("/nested/tree-collisions/12/second/first/bar/baz");
        Assert.assertEquals((Object)actionInvocation.configuration.actionClass, SecondAction.class);
        Assert.assertEquals((int)actionInvocation.uriParameters.size(), (int)1);
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("pre3")), Collections.singletonList("12"));
    }

    @Test
    public void lookupPrefixParameters() {
        DefaultActionConfigurationProvider defaultActionConfigurationProvider = new DefaultActionConfigurationProvider((ActionConfigurationBuilder)new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))));
        ActionInvocation actionInvocation = defaultActionConfigurationProvider.lookup("/nested/000/preParam2/parameter/42/postParam2");
        Assert.assertEquals((Object)actionInvocation.configuration.actionClass, ParameterAction.class);
        Assert.assertEquals((int)actionInvocation.uriParameters.size(), (int)4);
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("preParam1")), Collections.singletonList("000"));
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("preParam2")), Collections.singletonList("preParam2"));
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("endParam1")), Collections.singletonList("42"));
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("endParam2")), Collections.singletonList("postParam2"));
    }

    @Test
    public void postParametersOnly() {
        DefaultActionConfigurationProvider defaultActionConfigurationProvider = new DefaultActionConfigurationProvider((ActionConfigurationBuilder)new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))));
        ActionInvocation actionInvocation = defaultActionConfigurationProvider.lookup("/kitchen-sink/foo/bar/static/baz");
        Assert.assertSame((Object)actionInvocation.configuration.actionClass, KitchenSinkAction.class);
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("name")), Collections.singletonList("foo"));
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("value")), Collections.singletonList("bar"));
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("foo")), Collections.singletonList("baz"));
    }

    @Test
    public void recursion() {
        DefaultActionConfigurationProvider defaultActionConfigurationProvider = new DefaultActionConfigurationProvider((ActionConfigurationBuilder)new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), new HashSet<ActionConfigurator>(Arrays.asList(new JacksonActionConfigurator(), new BinaryActionConfigurator()))));
        ActionInvocation actionInvocation = defaultActionConfigurationProvider.lookup("/nested/12/foo");
        Assert.assertEquals((Object)actionInvocation.configuration.actionClass, FooAction.class);
        Assert.assertEquals((int)actionInvocation.uriParameters.size(), (int)1);
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("fooParam")), Collections.singletonList("12"));
        actionInvocation = defaultActionConfigurationProvider.lookup("/nested/12/foo-redux");
        Assert.assertEquals((Object)actionInvocation.configuration.actionClass, FooReduxAction.class);
        Assert.assertEquals((int)actionInvocation.uriParameters.size(), (int)1);
        Assert.assertEquals((Collection)((Collection)actionInvocation.uriParameters.get("fooParam")), Collections.singletonList("12"));
    }
}

