/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Inject;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.workflow.TypedExceptionHandler;

public class ErrorExceptionHandler
implements TypedExceptionHandler<ErrorException> {
    private final MVCConfiguration configuration;
    private final MessageProvider messageProvider;
    private final MessageStore messageStore;
    private final ResultStore resultStore;

    @Inject
    public ErrorExceptionHandler(ResultStore resultStore, MVCConfiguration configuration, MessageStore messageStore, MessageProvider messageProvider) {
        this.resultStore = resultStore;
        this.configuration = configuration;
        this.messageStore = messageStore;
        this.messageProvider = messageProvider;
    }

    @Override
    public void handle(ErrorException exception) {
        String code = exception.resultCode != null ? exception.resultCode : this.configuration.exceptionResultCode();
        this.resultStore.set(code);
        if (exception.lookUpMessage) {
            try {
                Object[] objectArray;
                String messageCode = "[" + exception.getClass().getSimpleName() + "]";
                if (exception.args != null) {
                    objectArray = exception.args;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = exception.getMessage();
                }
                Object[] args = objectArray;
                String message = this.messageProvider.getMessage(messageCode, args);
                this.messageStore.add(new SimpleMessage(MessageType.ERROR, messageCode, message));
            }
            catch (MissingMessageException missingMessageException) {
                // empty catch block
            }
        }
    }
}

