/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapBuilder<T, U> {
    public final Map<T, U> map = new LinkedHashMap<T, U>();

    public MapBuilder() {
    }

    public MapBuilder(T key, U value) {
        this.map.put(key, value);
    }

    public static <T> Map<T, T> asMap(T ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid mapping values. Must have a multiple of 2");
        }
        HashMap<T, T> map = new HashMap<T, T>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], values[i + 1]);
        }
        return map;
    }

    public static <T> Map<T, T> lmap(T ... values) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (int i = 0; i < values.length; i += 2) {
            T key = values[i];
            T value = values[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static <T, U> MapBuilder<T, U> map(T key, U value) {
        return new MapBuilder<T, U>(key, value);
    }

    public static <T, U> MapBuilder<T, U> map() {
        return new MapBuilder<T, U>();
    }

    public Map<T, U> done() {
        return this.map;
    }

    public MapBuilder<T, U> put(T key, U value) {
        this.map.put(key, value);
        return this;
    }
}

