/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.util.Classpath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassClasspathResolver<U> {
    private final Logger logger = LoggerFactory.getLogger(ClassClasspathResolver.class);

    public static ClassReader load(File file) throws IOException {
        try {
            return new ClassReader((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new IOException("Error parsing class file at [" + file.getAbsolutePath() + "]", e);
        }
    }

    public static ClassReader load(File jar, JarFile jarFile, JarEntry jarEntry) throws IOException {
        try {
            return new ClassReader(jarFile.getInputStream(jarEntry));
        }
        catch (IOException e) {
            throw new IOException("Error parsing class file at [" + jar.getAbsolutePath() + "!/" + jarEntry.getName() + "]", e);
        }
    }

    public Set<Class<U>> findByLocators(Test<Class<U>> test, boolean recursive, String ... locators) throws IOException {
        if (locators == null) {
            return null;
        }
        Classpath classpath = Classpath.getCurrentClassPath();
        List<String> names = classpath.getNames();
        HashSet<Class<U>> matches = new HashSet<Class<U>>();
        for (String name : names) {
            File f = new File(name);
            if (f.isDirectory()) {
                for (String locator : locators) {
                    Set<File> directories = this.findDirectories(f, locator);
                    for (File dir : directories) {
                        matches.addAll(this.loadFromDirectory(dir, test, recursive));
                    }
                }
                continue;
            }
            if (!f.isFile()) continue;
            matches.addAll(this.loadFromJar(f, test, recursive, Arrays.asList(locators), true));
        }
        return matches;
    }

    private Set<File> findDirectories(File dir, String locator) {
        HashSet<File> directories = new HashSet<File>();
        LinkedList<File> files = new LinkedList<File>(this.safeListFiles(dir, File::isDirectory));
        while (!files.isEmpty()) {
            File file = (File)files.poll();
            if (file.isDirectory() && file.getName().equals(locator)) {
                directories.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            files.addAll(this.safeListFiles(file, null));
        }
        return directories;
    }

    private Collection<Class<U>> loadFromDirectory(File dir, Test<Class<U>> test, boolean recursive) throws IOException {
        HashSet<Class<U>> matches = new HashSet<Class<U>>();
        LinkedList<File> files = new LinkedList<File>(this.safeListFiles(dir, null));
        while (!files.isEmpty()) {
            Testable<Class<U>> testable;
            File file = (File)files.poll();
            if (file.isDirectory() && recursive) {
                files.addAll(this.safeListFiles(file, null));
                continue;
            }
            if (!file.isFile() || (testable = test.prepare(file)) == null || !testable.passes()) continue;
            matches.add(testable.result());
        }
        return matches;
    }

    private Collection<Class<U>> loadFromJar(File f, Test<Class<U>> test, boolean recursive, Iterable<String> locators, boolean embeddable) throws IOException {
        JarFile jarFile;
        HashSet<Class<U>> matches = new HashSet<Class<U>>();
        try {
            jarFile = new JarFile(f);
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Error opening JAR file [" + f.getAbsolutePath() + "]", (Throwable)e);
            } else {
                this.logger.warn("Error opening JAR file [" + f.getAbsolutePath() + "]");
            }
            return Collections.emptyList();
        }
        Enumeration<JarEntry> en = jarFile.entries();
        block2: while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            String name = entry.getName();
            for (String locator : locators) {
                Testable<Class<U>> testable;
                int index = name.indexOf(locator + "/");
                boolean match = !embeddable && index == 0 || embeddable && index >= 0;
                if (!match || !(match = recursive || name.indexOf(47, index + locator.length() + 1) == -1) || (testable = test.prepare(f, jarFile, entry)) == null || !testable.passes()) continue;
                matches.add(testable.result());
                continue block2;
            }
        }
        jarFile.close();
        return matches;
    }

    private List<File> safeListFiles(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    public static interface Test<T> {
        public Testable<T> prepare(File var1) throws IOException;

        public Testable<T> prepare(File var1, JarFile var2, JarEntry var3) throws IOException;
    }

    public static interface Testable<T> {
        public boolean passes();

        public T result();
    }

    public static class IsA<U>
    implements Test<Class<U>> {
        private final Class<U> parent;

        public IsA(Class<U> parent) {
            this.parent = parent;
        }

        @Override
        public Testable<Class<U>> prepare(File file) throws IOException {
            if (!file.getName().endsWith(".class")) {
                return null;
            }
            return new IsATestable<U>(this.parent, ClassClasspathResolver.load(file));
        }

        @Override
        public Testable<Class<U>> prepare(File jar, JarFile jarFile, JarEntry jarEntry) throws IOException {
            if (!jarEntry.getName().endsWith(".class")) {
                return null;
            }
            return new IsATestable<U>(this.parent, ClassClasspathResolver.load(jar, jarFile, jarEntry));
        }

        private static class IsATestable<U>
        implements Testable<Class<U>> {
            private final ClassReader classReader;
            private final IsAClassVisitor<U> visitor;

            public IsATestable(Class<U> parent, ClassReader classReader) {
                this.visitor = new IsAClassVisitor<U>(parent);
                this.classReader = classReader;
            }

            @Override
            public boolean passes() {
                this.classReader.accept(this.visitor, 1);
                return this.visitor.isPasses();
            }

            @Override
            public Class<U> result() {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(this.classReader.getClassName().replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new PrimeException(e);
                }
            }

            private static class IsAClassVisitor<U>
            extends ClassVisitor {
                private final Class<U> parent;
                private boolean passes;

                private IsAClassVisitor(Class<U> parent) {
                    super(458752);
                    this.parent = parent;
                }

                public boolean isPasses() {
                    return this.passes;
                }

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    String parentInternalName = this.parent.getName().replace('.', '/');
                    this.passes = superName.equals(parentInternalName);
                    if (this.passes) {
                        return;
                    }
                    for (String anInterface : interfaces) {
                        this.passes = anInterface.equals(parentInternalName);
                        if (this.passes) break;
                    }
                    if (this.passes) {
                        return;
                    }
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (!superName.equals("java/lang/Object")) {
                        try {
                            InputStream is = classLoader.getResourceAsStream(superName.replace('.', '/') + ".class");
                            ClassReader reader = new ClassReader(is);
                            reader.accept((ClassVisitor)this, 1);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.passes) {
                        return;
                    }
                    for (String anInterface : interfaces) {
                        try {
                            InputStream is = classLoader.getResourceAsStream(anInterface.replace('.', '/') + ".class");
                            ClassReader reader = new ClassReader(is);
                            reader.accept((ClassVisitor)this, 1);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!this.passes) continue;
                        return;
                    }
                }
            }
        }
    }

    public static class AnnotatedWith<T extends Annotation, U>
    implements Test<Class<U>> {
        private final Class<T> annotation;

        public AnnotatedWith(Class<T> annotation) {
            this.annotation = annotation;
        }

        @Override
        public Testable<Class<U>> prepare(File file) throws IOException {
            if (!file.getName().endsWith(".class")) {
                return null;
            }
            return new AnnotatedWithTestable(this.annotation, ClassClasspathResolver.load(file));
        }

        @Override
        public Testable<Class<U>> prepare(File jar, JarFile jarFile, JarEntry jarEntry) throws IOException {
            if (!jarEntry.getName().endsWith(".class")) {
                return null;
            }
            return new AnnotatedWithTestable(this.annotation, ClassClasspathResolver.load(jar, jarFile, jarEntry));
        }

        private static class AnnotatedWithTestable<T extends Annotation, U>
        implements Testable<Class<U>> {
            private final ClassReader classReader;
            private final AnnotatedWithClassVisitor<T> visitor;

            public AnnotatedWithTestable(Class<T> annotation, ClassReader classReader) {
                this.visitor = new AnnotatedWithClassVisitor<T>(annotation);
                this.classReader = classReader;
            }

            @Override
            public boolean passes() {
                this.classReader.accept(this.visitor, 1);
                return this.visitor.isPasses();
            }

            @Override
            public Class<U> result() {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(this.classReader.getClassName().replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new PrimeException(e);
                }
            }

            private static class AnnotatedWithClassVisitor<T extends Annotation>
            extends ClassVisitor {
                private final Class<T> annotation;
                private boolean passes;

                private AnnotatedWithClassVisitor(Class<T> annotation) {
                    super(458752);
                    this.annotation = annotation;
                }

                public boolean isPasses() {
                    return this.passes;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    desc = desc.replaceAll("^L|;$", "");
                    desc = desc.replace('/', '.');
                    this.passes |= desc.equals(this.annotation.getName());
                    return null;
                }
            }
        }
    }
}

