/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayBuilder<T> {
    public final List<T> list = new ArrayList<T>();
    public final Class<T> type;

    public ArrayBuilder(Class<T> type, T ... values) {
        this.type = type;
        this.list.addAll(Arrays.asList(values));
    }

    public static <T> T[] asArray(Class<T> type, T ... values) {
        Object[] array = (Object[])Array.newInstance(type, values.length);
        return Arrays.asList(values).toArray(array);
    }

    public ArrayBuilder<T> add(T value) {
        this.list.add(value);
        return this;
    }

    public ArrayBuilder<T> addAll(T ... values) {
        this.list.addAll(Arrays.asList(values));
        return this;
    }

    public ArrayBuilder<T> addAll(Iterable<T> values) {
        for (T value : values) {
            this.list.add(value);
        }
        return this;
    }

    public T[] done() {
        Object[] array = (Object[])Array.newInstance(this.type, this.list.size());
        return this.list.toArray(array);
    }
}

