/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security.guice;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.security.AuthorizeMethodScheme;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.DefaultJWTConstraintsValidator;
import org.primeframework.mvc.security.DefaultJWTRequestAdapter;
import org.primeframework.mvc.security.DefaultJWTSecurityContext;
import org.primeframework.mvc.security.DefaultSavedRequestWorkflow;
import org.primeframework.mvc.security.DefaultSecurityWorkflow;
import org.primeframework.mvc.security.DefaultUserLoginConstraintValidator;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.ExplosiveVerifierProvider;
import org.primeframework.mvc.security.GCMCipherProvider;
import org.primeframework.mvc.security.JWTConstraintsValidator;
import org.primeframework.mvc.security.JWTRequestAdapter;
import org.primeframework.mvc.security.JWTSecurityContext;
import org.primeframework.mvc.security.JWTSecurityScheme;
import org.primeframework.mvc.security.SavedRequestWorkflow;
import org.primeframework.mvc.security.SecurityWorkflow;
import org.primeframework.mvc.security.UserLoginConstraintsValidator;
import org.primeframework.mvc.security.UserLoginSecurityScheme;
import org.primeframework.mvc.security.VerifierProvider;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.security.csrf.DefaultEncryptionBasedTokenCSRFProvider;
import org.primeframework.mvc.security.guice.SecuritySchemeFactory;

public class SecurityModule
extends AbstractModule {
    protected void configure() {
        this.bind(CSRFProvider.class).to(DefaultEncryptionBasedTokenCSRFProvider.class);
        this.bind(SecurityWorkflow.class).to(DefaultSecurityWorkflow.class);
        this.bind(SavedRequestWorkflow.class).to(DefaultSavedRequestWorkflow.class);
        this.bind(JWTConstraintsValidator.class).to(DefaultJWTConstraintsValidator.class);
        this.bind(JWTRequestAdapter.class).to(DefaultJWTRequestAdapter.class);
        this.bind(JWTSecurityContext.class).to(DefaultJWTSecurityContext.class);
        this.bind(UserLoginConstraintsValidator.class).to(DefaultUserLoginConstraintValidator.class);
        this.bind(VerifierProvider.class).to(ExplosiveVerifierProvider.class);
        SecuritySchemeFactory.addSecurityScheme(this.binder(), "jwt", JWTSecurityScheme.class);
        SecuritySchemeFactory.addSecurityScheme(this.binder(), "user", UserLoginSecurityScheme.class);
        SecuritySchemeFactory.addSecurityScheme(this.binder(), "authorize-method", AuthorizeMethodScheme.class);
        this.bind(CipherProvider.class).annotatedWith((Annotation)Names.named((String)"CBC")).to(CBCCipherProvider.class).asEagerSingleton();
        this.bind(CipherProvider.class).annotatedWith((Annotation)Names.named((String)"GCM")).to(GCMCipherProvider.class).asEagerSingleton();
        this.bind(CipherProvider.class).to(CBCCipherProvider.class).asEagerSingleton();
        this.bind(Encryptor.class).to(DefaultEncryptor.class);
    }
}

