/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.CipherProvider;

public class GCMCipherProvider
implements CipherProvider {
    private final Key key;

    @Inject
    public GCMCipherProvider(MVCConfiguration configuration) {
        this.key = configuration.cookieEncryptionKey();
    }

    @Override
    public Cipher getDecryptor(byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, this.key, new GCMParameterSpec(128, iv));
        return cipher;
    }

    @Override
    public Cipher getEncryptor(byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, this.key, new GCMParameterSpec(128, iv));
        return cipher;
    }
}

