/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Set;
import org.primeframework.mvc.security.UserLoginConstraintsValidator;
import org.primeframework.mvc.security.UserLoginSecurityContext;

public class DefaultUserLoginConstraintValidator
implements UserLoginConstraintsValidator {
    private UserLoginSecurityContext userLoginSecurityContext;

    @Inject(optional=true)
    public void setUserLoginSecurityContext(UserLoginSecurityContext userLoginSecurityContext) {
        this.userLoginSecurityContext = userLoginSecurityContext;
    }

    @Override
    public boolean validate(String[] constraints) {
        if (this.userLoginSecurityContext == null) {
            return true;
        }
        if (constraints.length > 0) {
            Set<String> userRoles = this.userLoginSecurityContext.getCurrentUsersRoles();
            return Arrays.stream(constraints).anyMatch(userRoles::contains);
        }
        return true;
    }
}

