/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import org.primeframework.mvc.security.JWTRequestAdapter;

public class DefaultJWTRequestAdapter
implements JWTRequestAdapter {
    private static final String BearerScheme = "bearer ";
    private static final String JWTScheme = "jwt ";
    protected final HTTPRequest request;
    protected final HTTPResponse response;

    @Inject
    public DefaultJWTRequestAdapter(HTTPRequest request, HTTPResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public String getEncodedJWT() {
        Cookie cookie;
        String authorization = this.request.getHeader("Authorization");
        if (authorization != null) {
            if (authorization.toLowerCase().startsWith(BearerScheme)) {
                return authorization.substring(BearerScheme.length());
            }
            if (authorization.toLowerCase().startsWith(JWTScheme)) {
                return authorization.substring(JWTScheme.length());
            }
        }
        return (cookie = this.request.getCookie(this.cookieName())) != null ? cookie.value : null;
    }

    @Override
    public String invalidateJWT() {
        Cookie cookie = this.request.getCookie(this.cookieName());
        if (cookie != null) {
            String token = cookie.value;
            cookie.value = null;
            cookie.maxAge = 0L;
            cookie.path = "/";
            this.response.addCookie(cookie);
            return token;
        }
        return null;
    }

    @Override
    public boolean requestContainsJWT() {
        return this.getEncodedJWT() != null;
    }

    protected String cookieName() {
        return "access_token";
    }
}

