/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.el.Accessor;
import org.primeframework.mvc.parameter.el.Expression;
import org.primeframework.mvc.parameter.el.MemberAccessor;
import org.primeframework.mvc.util.TypeTools;

public class MapAccessor
extends Accessor {
    final Object key;
    final MemberAccessor memberAccessor;

    public MapAccessor(ConverterProvider converterProvider, Accessor accessor, String index, MemberAccessor memberAccessor) {
        super(converterProvider, accessor);
        String path = memberAccessor.toString();
        Type objectType = this.type;
        this.memberAccessor = memberAccessor;
        Type[] types = TypeTools.mapTypes(objectType, path);
        Class<?> classDeclaringMap = memberAccessor.field != null ? memberAccessor.field.getDeclaringClass() : memberAccessor.propertyInfo.getDeclaringClass();
        Type valueType = types[1];
        this.type = valueType instanceof TypeVariable ? TypeTools.resolveGenericType(classDeclaringMap, this.currentClass, (TypeVariable)valueType) : types[1];
        Type keyType = types[0];
        keyType = keyType instanceof TypeVariable ? TypeTools.resolveGenericType(classDeclaringMap, this.currentClass, (TypeVariable)keyType) : TypeTools.rawType(keyType);
        if (!(keyType instanceof Class)) {
            throw new IllegalStateException("Unable to determine concrete type of Map key for [" + String.valueOf(this) + "]");
        }
        Type keyClass = keyType;
        GlobalConverter converter = converterProvider.lookup((Class<?>)keyClass);
        if (converter == null) {
            throw new ConversionException("No type converter is registered for the type [" + String.valueOf(keyClass) + "], which is the type for the key of the map at [" + path + "]");
        }
        this.key = index == null || index.length() == 0 ? index : converter.convertFromStrings(keyClass, null, path, index);
    }

    @Override
    public Object get(Expression expression) {
        return ((Map)this.object).get(this.key);
    }

    @Override
    public MemberAccessor getMemberAccessor() {
        return this.memberAccessor;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public void set(String[] values, Expression expression) {
        this.set(this.convert(expression, this.memberAccessor.field, values), expression);
    }

    @Override
    public void set(Object value, Expression expression) {
        if (value instanceof String[] && ((String[])value).length == 1) {
            ((Map)this.object).put(this.key, ((String[])value)[0]);
        } else {
            ((Map)this.object).put(this.key, value);
        }
    }

    @Override
    protected <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.memberAccessor.getAnnotation(type);
    }
}

