/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.lang.reflect.Type;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;
import org.primeframework.mvc.util.LocaleTools;

@GlobalConverter
public class LocaleConverter
extends AbstractGlobalConverter {
    protected static final String LOCALE_EXT_MARKER = "_#";

    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        return value.toString();
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank(value)) {
            return Locale.ROOT;
        }
        try {
            return this._deserializeLocale(value);
        }
        catch (Exception e) {
            throw new ConversionException("Invalid locale [" + value + "]", e);
        }
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        return this.toLocale(values);
    }

    private Locale _deSerializeBCP47Locale(String value, int ix, String first, String second, int extMarkerIx) {
        String third = "";
        try {
            if (extMarkerIx > 0 && extMarkerIx > ix) {
                third = value.substring(ix + 1, extMarkerIx);
            }
            if ((value = value.substring(extMarkerIx + 2)).indexOf(95) < 0 && value.indexOf(45) < 0) {
                return new Locale.Builder().setLanguage(first).setRegion(second).setVariant(third).setScript(value).build();
            }
            if (value.indexOf(95) < 0) {
                ix = value.indexOf(45);
                return new Locale.Builder().setLanguage(first).setRegion(second).setVariant(third).setExtension(value.charAt(0), value.substring(ix + 1)).build();
            }
            ix = value.indexOf(95);
            return new Locale.Builder().setLanguage(first).setRegion(second).setVariant(third).setScript(value.substring(0, ix)).setExtension(value.charAt(ix + 1), value.substring(ix + 3)).build();
        }
        catch (IllformedLocaleException ex) {
            return Locale.of(first, second, third);
        }
    }

    private Locale _deserializeLocale(String value) {
        int ix = LocaleTools.firstHyphenOrUnderscore(value);
        if (ix < 0) {
            return Locale.of(value);
        }
        String first = value.substring(0, ix);
        if ((ix = LocaleTools.firstHyphenOrUnderscore(value = value.substring(ix + 1))) < 0) {
            int length = value.length();
            if (length == 2 || length == 3) {
                return Locale.of(first, value);
            }
            return Locale.of(first, "", value);
        }
        String second = value.substring(0, ix);
        int extMarkerIx = value.indexOf(LOCALE_EXT_MARKER);
        if (extMarkerIx < 0) {
            return Locale.of(first, second, value.substring(ix + 1));
        }
        return this._deSerializeBCP47Locale(value, ix, first, second, extMarkerIx);
    }

    private Locale toLocale(String[] parts) {
        if (parts.length == 1) {
            try {
                return this._deserializeLocale(parts[0]);
            }
            catch (Exception e) {
                throw new ConversionException("Invalid locale [" + parts[0] + "]", e);
            }
        }
        if (parts.length == 2) {
            return Locale.of(parts[0], parts[1]);
        }
        return Locale.of(parts[0], parts[1], parts[2]);
    }
}

