/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.MultipleParametersUnsupportedException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;

@GlobalConverter
public class LocalDateConverter
extends AbstractGlobalConverter {
    private final boolean emptyIsNull;

    @Inject
    public LocalDateConverter(MVCConfiguration configuration) {
        this.emptyIsNull = configuration.emptyParametersAreNull();
    }

    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        String format = attributes.get("dateTimeFormat");
        DateTimeFormatter formatter = format != null ? (format.indexOf(91) == 0 ? DateTimeFormatter.ofPattern(format.substring(1, format.indexOf("]", 1))) : DateTimeFormatter.ofPattern(format)) : DateTimeFormatter.ISO_LOCAL_DATE;
        return ((LocalDate)value).format(formatter);
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        if (this.emptyIsNull && StringUtils.isBlank(value)) {
            return null;
        }
        String format = attributes.get("dateTimeFormat");
        DateTimeFormatter formatter = format != null ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ISO_LOCAL_DATE;
        return this.toLocalDate(value, formatter);
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        throw new MultipleParametersUnsupportedException("You are attempting to map a form field that contains multiple parameters to a property on the action class that is of type LocalDate. This isn't allowed.");
    }

    private LocalDate toLocalDate(String value, DateTimeFormatter formatter) {
        try {
            return LocalDate.parse(value, formatter);
        }
        catch (DateTimeParseException e) {
            throw new ConversionException("Invalid date [" + value + "] for format [" + String.valueOf(formatter) + "]", e);
        }
    }
}

