/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.io.File;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;

@GlobalConverter
public class FileConverter
extends AbstractGlobalConverter {
    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        File file = (File)value;
        return file.getAbsolutePath();
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        String parent;
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if (value.charAt(0) == File.separatorChar || value.charAt(0) == '\\') {
            return new File(value);
        }
        if (attributes != null && (parent = attributes.get("parentDir")) != null) {
            return new File(parent, value);
        }
        return new File(value);
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        String joined = String.join((CharSequence)File.separator, values);
        return this.stringToObject(joined, convertTo, attributes, expression);
    }
}

