/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.util.TypeTools;

public abstract class AbstractPrimitiveConverter
extends AbstractGlobalConverter {
    private final boolean emptyIsNull;

    protected AbstractPrimitiveConverter(MVCConfiguration configuration) {
        this.emptyIsNull = configuration.emptyParametersAreNull();
    }

    protected abstract Object defaultPrimitive(Class var1, Map<String, String> var2) throws ConversionException, ConverterStateException;

    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        Class<?> rawType = TypeTools.rawType(convertFrom);
        return this.primitiveToString(value, rawType, attributes);
    }

    protected abstract String primitiveToString(Object var1, Class var2, Map<String, String> var3) throws ConversionException, ConverterStateException;

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        if (this.emptyIsNull && StringUtils.isBlank(value)) {
            value = null;
        }
        Class<?> rawType = TypeTools.rawType(convertTo);
        if (value == null && rawType.isPrimitive()) {
            return this.defaultPrimitive(rawType, attributes);
        }
        if (value == null) {
            return null;
        }
        return this.stringToPrimitive(value, rawType, attributes);
    }

    protected abstract Object stringToPrimitive(String var1, Class var2, Map<String, String> var3) throws ConversionException, ConverterStateException;

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        throw new ConverterStateException("The primitive converter doesn't support String[] to Object conversion.");
    }
}

