/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.parameter.convert.AnnotationConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.util.TypeTools;

public abstract class AbstractAnnotationConverter<T extends Annotation>
implements AnnotationConverter<T> {
    @Override
    public Object convertFromStrings(T annotation, String[] values, Type convertTo, Map<String, String> dynamicAttributes, String expression) throws ConversionException, ConverterStateException {
        Class<?> rawType = TypeTools.rawType(convertTo);
        if (values == null || values.length <= 1) {
            String value;
            String string = value = values != null && values.length == 1 ? values[0] : null;
            if (rawType.isArray()) {
                if (rawType.getComponentType().isArray()) {
                    throw new ConverterStateException("Converter [" + String.valueOf(this.getClass()) + "] does not support conversion to multi-dimensional arrays of type [" + String.valueOf(convertTo) + "]");
                }
                return this.stringToArray(annotation, value, convertTo, dynamicAttributes, expression);
            }
            return this.stringToObject(annotation, value, convertTo, dynamicAttributes, expression);
        }
        if (rawType.isArray()) {
            if (rawType.getComponentType().isArray()) {
                throw new ConverterStateException("Converter [" + String.valueOf(this.getClass()) + "] does not support conversion to multi-dimensional arrays of type [" + String.valueOf(convertTo) + "]");
            }
            return this.stringsToArray(annotation, values, convertTo, dynamicAttributes, expression);
        }
        return this.stringsToObject(annotation, values, convertTo, dynamicAttributes, expression);
    }

    public String convertToString(T annotation, Object value, Type convertFrom, Map<String, String> dynamicAttributes, String expression) throws ConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        Class<?> rawType = TypeTools.rawType(convertFrom);
        if (rawType.isArray()) {
            return this.arrayToString(annotation, value, convertFrom, dynamicAttributes, expression);
        }
        return this.objectToString(annotation, value, convertFrom, dynamicAttributes, expression);
    }

    protected String arrayToString(T annotation, Object value, Type convertFrom, Map<String, String> dynamicAttributes, String expression) throws ConversionException {
        Class<?> rawType = TypeTools.rawType(convertFrom);
        if (!rawType.isArray()) {
            throw new ConversionException("The convertFrom parameter must be an array type");
        }
        if (!value.getClass().isArray()) {
            throw new ConversionException("The value is not an array");
        }
        if (value.getClass().getComponentType().isArray()) {
            throw new ConversionException("The value is a multi-dimensional array, which is not supported by the AbstractConverter");
        }
        int length = Array.getLength(value);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(value, i);
            str.append(this.convertToString(annotation, o, value.getClass().getComponentType(), dynamicAttributes));
            if (i + 1 >= length) continue;
            str.append(",");
        }
        return str.toString();
    }

    protected abstract String objectToString(T var1, Object var2, Type var3, Map<String, String> var4, String var5) throws ConversionException, ConverterStateException;

    protected Class<?> parameterType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    protected Object stringToArray(T annotation, String value, Type convertTo, Map<String, String> dynamicAttributes, String expression) throws ConversionException {
        Object finalArray;
        if (value == null) {
            return null;
        }
        Class<?> rawType = TypeTools.rawType(convertTo);
        if (StringUtils.isBlank(value)) {
            finalArray = Array.newInstance(rawType.getComponentType(), 0);
        } else {
            String[] parts = value.split(",");
            finalArray = Array.newInstance(rawType.getComponentType(), parts.length);
            for (int i = 0; i < parts.length; ++i) {
                Object singleValue = this.stringToObject(annotation, parts[i], rawType.getComponentType(), dynamicAttributes, expression);
                Array.set(finalArray, i, singleValue);
            }
        }
        return finalArray;
    }

    protected abstract Object stringToObject(T var1, String var2, Type var3, Map<String, String> var4, String var5) throws ConversionException, ConverterStateException;

    protected Object stringsToArray(T annotation, String[] values, Type convertTo, Map<String, String> dynamicAttributes, String expression) throws ConversionException {
        Object finalArray;
        if (values == null) {
            return null;
        }
        Class<?> rawType = TypeTools.rawType(convertTo);
        if (values.length == 0) {
            finalArray = Array.newInstance(rawType.getComponentType(), 0);
        } else {
            finalArray = Array.newInstance(rawType.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Object singleValue = this.stringToObject(annotation, values[i], rawType.getComponentType(), dynamicAttributes, expression);
                Array.set(finalArray, i, singleValue);
            }
        }
        return finalArray;
    }

    protected abstract Object stringsToObject(T var1, String[] var2, Type var3, Map<String, String> var4, String var5) throws ConversionException, ConverterStateException;
}

