/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message.scope;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.scope.Scope;

public class RequestScope
implements Scope {
    public static final String KEY = "primeMessages";
    private final HTTPRequest request;

    @Inject
    public RequestScope(HTTPRequest request) {
        this.request = request;
    }

    @Override
    public void add(Message message) {
        ArrayList<Message> messages = (ArrayList<Message>)this.request.getAttribute(KEY);
        if (messages == null) {
            messages = new ArrayList<Message>();
            this.request.setAttribute(KEY, messages);
        }
        messages.add(message);
    }

    @Override
    public void addAll(Collection<Message> messages) {
        ArrayList<Message> scopeMessages = (ArrayList<Message>)this.request.getAttribute(KEY);
        if (scopeMessages == null) {
            scopeMessages = new ArrayList<Message>();
            this.request.setAttribute(KEY, scopeMessages);
        }
        scopeMessages.addAll(messages);
    }

    @Override
    public void clear() {
        this.request.removeAttribute(KEY);
    }

    @Override
    public List<Message> get() {
        List messages = (List)this.request.getAttribute(KEY);
        if (messages != null) {
            return messages;
        }
        return Collections.emptyList();
    }
}

