/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.locale;

import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.util.Locale;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.guice.Nullable;
import org.primeframework.mvc.locale.LocaleProvider;
import org.primeframework.mvc.util.LocaleTools;

public class DefaultLocaleProvider
implements LocaleProvider {
    private final MVCConfiguration configuration;
    private final HTTPRequest request;
    private final HTTPResponse response;

    @Inject
    public DefaultLocaleProvider(@Nullable HTTPRequest request, @Nullable HTTPResponse response, MVCConfiguration configuration) {
        this.request = request;
        this.response = response;
        this.configuration = configuration;
    }

    public Locale get() {
        if (this.request == null) {
            return Locale.getDefault();
        }
        String key = this.configuration.localeCookieName();
        Cookie cookie = this.request.getCookie(key);
        if (cookie != null && cookie.value != null) {
            try {
                return LocaleTools.toLocale(cookie.value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.request.getLocale();
    }

    @Override
    public void set(Locale locale) {
        if (this.response == null) {
            return;
        }
        String key = this.configuration.localeCookieName();
        Cookie cookie = new Cookie(key, locale != null ? locale.toString() : null);
        cookie.maxAge = locale != null ? Integer.MAX_VALUE : 0L;
        cookie.path = "/";
        this.response.addCookie(cookie);
    }
}

