/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import io.fusionauth.http.server.HTTPRequest;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

public class HTTPTools {
    private static final Pattern DoubleSlash = Pattern.compile("/{2,}");

    public static String getOriginHeader(HTTPRequest request) {
        String value = ObjectUtils.defaultIfNull(request.getHeader("Origin"), request.getHeader("Referer"));
        if (value == null || value.equals("null")) {
            return null;
        }
        return value;
    }

    public static String getRequestURI(HTTPRequest request) {
        String context;
        String uri = request.getPath();
        int semicolon = uri.indexOf(59);
        if (semicolon >= 0) {
            uri = uri.substring(0, semicolon);
        }
        if ((context = request.getContextPath()).length() > 0) {
            return uri.substring(context.length());
        }
        return DoubleSlash.matcher(uri).replaceAll("/");
    }

    public static String sanitizeURI(String uri) {
        if (uri == null) {
            return null;
        }
        char[] ca = uri.replace("%2E", ".").toCharArray();
        int dots = 0;
        int slash = 0;
        boolean goodSegment = false;
        LinkedList<String> segments = new LinkedList<String>();
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (c == '/') {
                if (goodSegment || dots > 2) {
                    segments.addLast(new String(ca, slash, i - slash));
                } else if (dots == 2) {
                    if (segments.isEmpty()) {
                        return null;
                    }
                    segments.removeLast();
                }
                slash = i;
                dots = 0;
                goodSegment = false;
                continue;
            }
            if (c == '.') {
                ++dots;
                continue;
            }
            goodSegment = true;
            dots = 0;
        }
        if (goodSegment) {
            segments.addLast(new String(ca, slash, ca.length - slash));
        }
        return String.join((CharSequence)"", segments);
    }
}

