/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.cors;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import org.primeframework.mvc.cors.CORSConfiguration;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.cors.CORSDebugger;
import org.primeframework.mvc.cors.CORSFilter;
import org.primeframework.mvc.workflow.MVCWorkflow;
import org.primeframework.mvc.workflow.WorkflowChain;

public class CORSRequestWorkflow
implements MVCWorkflow {
    private final CORSConfigurationProvider corsConfigurationProvider;
    private final HTTPRequest request;
    private final HTTPResponse response;
    private CORSDebugger debugger;

    @Inject
    public CORSRequestWorkflow(CORSConfigurationProvider corsConfigurationProvider, HTTPRequest request, HTTPResponse response) {
        this.corsConfigurationProvider = corsConfigurationProvider;
        this.request = request;
        this.response = response;
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        CORSConfiguration corsConfiguration = this.corsConfigurationProvider.get();
        if (corsConfiguration != null) {
            CORSFilter corsFilter = new CORSFilter().withAllowCredentials(corsConfiguration.allowCredentials).withAllowedHTTPHeaders(corsConfiguration.allowedHeaders).withAllowedHTTPMethods(corsConfiguration.allowedMethods).withAllowedOrigins(corsConfiguration.allowedOrigins).withDebugEnabled(corsConfiguration.debug).withDebugger(this.debugger).withExcludedPathPattern(corsConfiguration.excludedPathPattern).withIncludedPathPattern(corsConfiguration.includedPathPattern).withIncludeURIPredicate(corsConfiguration.includeURIPredicate).withExcludeURIPredicate(corsConfiguration.excludeURIPredicate).withExposedHeaders(corsConfiguration.exposedHeaders).withPreflightMaxAge(corsConfiguration.preflightMaxAgeInSeconds);
            corsFilter.doFilter(this.request, this.response, workflowChain);
        } else {
            workflowChain.continueWorkflow();
        }
    }

    @Inject(optional=true)
    public void setDebugger(CORSDebugger debugger) {
        this.debugger = debugger;
    }
}

