/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.cors;

import io.fusionauth.http.HTTPMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.primeframework.mvc.util.Buildable;

public class CORSConfiguration
implements Buildable<CORSConfiguration> {
    public boolean allowCredentials;
    public List<String> allowedHeaders = new ArrayList<String>();
    public List<HTTPMethod> allowedMethods = new ArrayList<HTTPMethod>();
    public List<URI> allowedOrigins = new ArrayList<URI>();
    public boolean debug;
    public Predicate<String> excludeURIPredicate;
    public Pattern excludedPathPattern;
    public List<String> exposedHeaders = new ArrayList<String>();
    public Predicate<String> includeURIPredicate;
    public Pattern includedPathPattern;
    public int preflightMaxAgeInSeconds;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CORSConfiguration that = (CORSConfiguration)o;
        return this.allowCredentials == that.allowCredentials && this.debug == that.debug && this.preflightMaxAgeInSeconds == that.preflightMaxAgeInSeconds && Objects.equals(this.allowedHeaders, that.allowedHeaders) && Objects.equals(this.allowedMethods, that.allowedMethods) && Objects.equals(this.allowedOrigins, that.allowedOrigins) && Objects.equals(this.exposedHeaders, that.exposedHeaders);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allowCredentials, this.allowedHeaders, this.allowedMethods, this.allowedOrigins, this.debug, this.exposedHeaders, this.preflightMaxAgeInSeconds);
    }

    public CORSConfiguration withAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public CORSConfiguration withAllowedHeaders(String ... headers) {
        this.allowedHeaders.clear();
        this.allowedHeaders.addAll(List.of(headers));
        return this;
    }

    public CORSConfiguration withAllowedMethods(HTTPMethod ... methods) {
        this.allowedMethods.clear();
        this.allowedMethods.addAll(List.of(methods));
        return this;
    }

    public CORSConfiguration withAllowedOrigins(URI ... origins) {
        this.allowedOrigins.clear();
        this.allowedOrigins.addAll(List.of(origins));
        return this;
    }

    public CORSConfiguration withDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public CORSConfiguration withExcludeURIPredicate(Predicate<String> excludeURIPredicate) {
        this.excludeURIPredicate = excludeURIPredicate;
        this.checkExclusiveMatching();
        return this;
    }

    public CORSConfiguration withExcludedPathPattern(Pattern pattern) {
        this.excludedPathPattern = pattern;
        this.checkExclusiveMatching();
        return this;
    }

    public CORSConfiguration withExposedHeaders(String ... headers) {
        this.exposedHeaders.clear();
        this.exposedHeaders.addAll(List.of(headers));
        return this;
    }

    public CORSConfiguration withIncludeURIPredicate(Predicate<String> includeURIPredicate) {
        this.includeURIPredicate = includeURIPredicate;
        this.checkExclusiveMatching();
        return this;
    }

    public CORSConfiguration withIncludedPathPattern(Pattern pattern) {
        this.includedPathPattern = pattern;
        this.checkExclusiveMatching();
        return this;
    }

    public CORSConfiguration withPreflightMaxAgeInSeconds(int maxAge) {
        this.preflightMaxAgeInSeconds = maxAge;
        return this;
    }

    private void checkExclusiveMatching() {
        if (this.excludedPathPattern != null && this.includedPathPattern != null) {
            throw new IllegalStateException("You cannot use both withExcludedPathPattern and withIncludedPathPattern. You must use one or the other.");
        }
        if (this.includeURIPredicate != null && this.excludeURIPredicate != null) {
            throw new IllegalStateException("You cannot use both withIncludeURIPredicate and withExcludeURIPredicate. You must use one or the other.");
        }
        if (this.includeURIPredicate != null ^ this.excludeURIPredicate != null && this.excludedPathPattern != null ^ this.includedPathPattern != null) {
            throw new IllegalStateException("You cannot use both a path (withIncludedPathPattern/withExcludedPathPattern) and predicate based (withIncludeURIPredicate/withExcludeURIPredicate). You must use one or the other.");
        }
    }
}

