/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.message;

import com.google.inject.Inject;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.control.AbstractControl;
import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;

@ControlAttributes(required={@ControlAttribute(name="key", types={String.class})}, optional={@ControlAttribute(name="values", types={List.class})})
public class Message
extends AbstractControl
implements TemplateMethodModelEx {
    private final MessageProvider messageProvider;

    @Inject
    public Message(MessageProvider messageProvider) {
        this.messageProvider = messageProvider;
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() < 1) {
            throw new TemplateModelException("Invalid parameters to the message method. This method takes one or more parameters like this: message(key) or message(key, values...)");
        }
        String key = arguments.get(0).toString();
        return this.messageProvider.getMessage(key, arguments.subList(1, arguments.size()).toArray());
    }

    @Override
    protected void addAdditionalAttributes() {
        String message;
        String key = (String)this.attributes.remove("key");
        String defaultMesg = (String)this.attributes.remove("default");
        ArrayList values = (ArrayList)this.attributes.remove("values");
        if (values == null) {
            values = new ArrayList();
        }
        try {
            message = this.messageProvider.getMessage(key, values.toArray());
        }
        catch (MissingMessageException e) {
            message = defaultMesg;
        }
        if (message == null) {
            throw new PrimeException("The message for the key [" + key + "] is missing and there was no default set using the [default] attribute.");
        }
        this.attributes.put("message", message);
    }

    @Override
    protected String endTemplateName() {
        return "message.ftl";
    }

    @Override
    protected String startTemplateName() {
        return null;
    }
}

