/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;
import org.primeframework.mvc.control.form.Select;

@ControlAttributes(required={@ControlAttribute(name="name", types={String.class})}, optional={@ControlAttribute(name="disabled", types={boolean.class, Boolean.class}), @ControlAttribute(name="includeBlank", types={boolean.class, Boolean.class}), @ControlAttribute(name="multiple", types={boolean.class, Boolean.class}), @ControlAttribute(name="readonly", types={boolean.class, Boolean.class}), @ControlAttribute(name="required", types={boolean.class, Boolean.class}), @ControlAttribute(name="size", types={int.class, Number.class}), @ControlAttribute(name="tabindex", types={int.class, Number.class})})
public class CountrySelect
extends Select {
    @Override
    protected Map<String, Object> makeParameters() {
        String preferred;
        LinkedHashMap<String, String> countries = new LinkedHashMap<String, String>();
        if (this.attributes.containsKey("includeBlank") && ((Boolean)this.attributes.get("includeBlank")).booleanValue()) {
            countries.put("", "");
        }
        if ((preferred = (String)this.attributes.get("preferredCodes")) != null) {
            String[] parts;
            for (String part : parts = preferred.split(",")) {
                Locale locale = new Locale("", part);
                countries.put(part, locale.getDisplayCountry(locale));
            }
        }
        TreeSet<Locale> alphabetical = new TreeSet<Locale>(new LocaleComparator((Locale)this.localeProvider.get()));
        Locale[] locales = Locale.getAvailableLocales();
        for (Locale locale : locales) {
            if (!StringUtils.isNotBlank(locale.getCountry()) || !StringUtils.isNotBlank(locale.getDisplayCountry(locale))) continue;
            alphabetical.add(locale);
        }
        for (Locale locale : alphabetical) {
            if (countries.containsKey(locale.getCountry())) continue;
            countries.put(locale.getCountry(), locale.getDisplayCountry((Locale)this.localeProvider.get()));
        }
        this.attributes.put("items", countries);
        return super.makeParameters();
    }

    public static class LocaleComparator
    implements Comparator<Locale> {
        private final Locale displayLocale;

        public LocaleComparator(Locale displayLocale) {
            this.displayLocale = displayLocale;
        }

        @Override
        public int compare(Locale l1, Locale l2) {
            return l1.getDisplayCountry(this.displayLocale).compareTo(l2.getDisplayCountry(this.displayLocale));
        }
    }
}

