/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;
import org.primeframework.mvc.control.form.AbstractInput;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public abstract class AbstractCheckedInput
extends AbstractInput {
    private final ExpressionEvaluator expressionEvaluator;

    @Inject
    public AbstractCheckedInput(ExpressionEvaluator expressionEvaluator) {
        super(true);
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    protected void addAdditionalAttributes() {
        super.addAdditionalAttributes();
        String name = (String)this.attributes.get("name");
        Object action = this.currentInvocation().action;
        if (!this.attributes.containsKey("checked") && action != null) {
            Object value = this.expressionEvaluator.getValue(name, action);
            boolean checked = false;
            if (value == null && this.attributes.containsKey("defaultChecked")) {
                checked = (Boolean)this.attributes.get("defaultChecked");
            } else if (value != null) {
                String valueAttr = (String)this.attributes.get("value");
                if (value instanceof Iterable) {
                    Iterable iterable = (Iterable)value;
                    for (Object o : iterable) {
                        if (!o.toString().equals(valueAttr)) continue;
                        checked = true;
                        break;
                    }
                } else if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object arrayValue = Array.get(value, i);
                        if (!arrayValue.toString().equals(valueAttr)) continue;
                        checked = true;
                        break;
                    }
                } else {
                    checked = value.toString().equals(valueAttr);
                }
            }
            if (checked) {
                this.attributes.put("checked", "checked");
            }
        } else if (this.attributes.containsKey("checked") && ((Boolean)this.attributes.get("checked")).booleanValue()) {
            this.attributes.put("checked", "checked");
        } else {
            this.attributes.remove("checked");
        }
        this.attributes.remove("defaultChecked");
    }

    @Override
    protected Map<String, Object> makeParameters() {
        Map<String, Object> params = super.makeParameters();
        String uncheckedValue = (String)this.attributes.remove("uncheckedValue");
        params.put("uncheckedValue", Objects.requireNonNullElse(uncheckedValue, ""));
        return params;
    }
}

