/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.Patch;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.content.json.BaseJacksonContentHandler;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonPatchContentHandler
extends BaseJacksonContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(JacksonPatchContentHandler.class);

    @Inject
    public JacksonPatchContentHandler(HTTPRequest request, ActionInvocationStore store, ObjectMapper objectMapper, ExpressionEvaluator expressionEvaluator, MessageProvider messageProvider, MessageStore messageStore) {
        super(request, store, objectMapper, expressionEvaluator, messageProvider, messageStore);
    }

    @Override
    protected void handle(Object action, Object currentValue, String contentType, JacksonActionConfiguration.RequestMember requestMember) throws IOException, JsonPatchException {
        if (requestMember.jsonPatch == null) {
            this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[PatchNotSupported]", this.messageProvider.getMessage("[PatchNotSupported]", contentType)));
            throw new ValidationException();
        }
        if (currentValue == null) {
            logger.debug("Unable to process the request using [Content-Type] value of [" + contentType + "]. Missing an existing value to patch.");
            this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[NotFoundException]", this.messageProvider.getMessage("[NotFoundException]", new Object[0])));
            throw new ErrorException("missing");
        }
        Patch patch = (Patch)this.objectMapper.readerFor(contentType.equals("application/json-patch+json") ? JsonPatch.class : JsonMergePatch.class).readValue(this.request.getInputStream());
        JsonNode patched = patch.apply(this.objectMapper.valueToTree(currentValue));
        Object patchedObject = this.objectMapper.readerFor(requestMember.type).readValue(patched);
        this.expressionEvaluator.setValue(requestMember.name, action, patchedObject);
    }
}

