/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.content.ContentHandler;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.validation.ValidationException;

public class DefaultContentHandler
implements ContentHandler {
    private final MessageProvider messageProvider;
    private final MessageStore messageStore;
    private final HTTPRequest request;
    private final ActionInvocationStore store;

    @Inject
    public DefaultContentHandler(HTTPRequest request, ActionInvocationStore store, MessageProvider messageProvider, MessageStore messageStore) {
        this.request = request;
        this.messageProvider = messageProvider;
        this.messageStore = messageStore;
        this.store = store;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void handle() throws IOException {
        ActionInvocation actionInvocation = this.store.getCurrent();
        if (actionInvocation != null && actionInvocation.configuration != null && this.request.hasBody()) {
            String contentType = this.request.getContentType();
            if (contentType == null || contentType.isBlank()) {
                this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[MissingContentType]", this.messageProvider.getMessage("[MissingContentType]", new Object[0])));
            } else {
                this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[UnsupportedContentType]", this.messageProvider.getMessage("[UnsupportedContentType]", contentType)));
            }
            throw new ValidationException();
        }
    }
}

