/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractRedirectResult;
import org.primeframework.mvc.action.result.annotation.Redirect;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public class RedirectResult
extends AbstractRedirectResult<Redirect> {
    @Inject
    public RedirectResult(MessageStore messageStore, ExpressionEvaluator expressionEvaluator, HTTPResponse response, HTTPRequest request, ActionInvocationStore actionInvocationStore) {
        super(expressionEvaluator, actionInvocationStore, messageStore, request, response);
    }

    @Override
    public boolean execute(Redirect redirect) throws IOException {
        this.moveMessagesToFlash();
        this.addCacheControlHeader(redirect, this.response);
        this.sendRedirect(null, redirect.uri(), redirect.encodeVariables(), redirect.perm());
        return true;
    }

    @Override
    protected String getCacheControl(Redirect result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(Redirect result) {
        return result.disableCacheControl();
    }

    public static class RedirectImpl
    implements Redirect {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final boolean encode;
        private final boolean perm;
        private final String uri;

        public RedirectImpl(String uri, String code, boolean perm, boolean encode) {
            this.cacheControl = "no-cache";
            this.disableCacheControl = false;
            this.encode = encode;
            this.code = code;
            this.perm = perm;
            this.uri = uri;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Redirect.class;
        }

        @Override
        public String cacheControl() {
            return this.cacheControl;
        }

        @Override
        public String code() {
            return this.code;
        }

        @Override
        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        @Override
        public boolean encodeVariables() {
            return this.encode;
        }

        @Override
        public boolean perm() {
            return this.perm;
        }

        @Override
        public String uri() {
            return this.uri;
        }
    }
}

