/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.Injector;
import io.fusionauth.http.server.Instrumenter;

public class PrimeMVCInstrumenter
implements Instrumenter {
    private volatile Counter acceptedConnections;
    private volatile Counter acceptedRequests;
    private volatile Counter badRequests;
    private volatile Counter bytesRead;
    private volatile Counter bytesWritten;
    private volatile Counter chunkedRequests;
    private volatile Counter chunkedResponses;
    private volatile Counter connectionsClosed;
    private volatile Counter threads;

    public void acceptedConnection() {
        this.inc(this.acceptedConnections, 1L);
    }

    public void acceptedRequest() {
        this.inc(this.acceptedRequests, 1L);
    }

    public void badRequest() {
        this.inc(this.badRequests, 1L);
    }

    public void chunkedRequest() {
        this.inc(this.chunkedRequests, 1L);
    }

    public void chunkedResponse() {
        this.inc(this.chunkedResponses, 1L);
    }

    public void connectionClosed() {
        this.inc(this.connectionsClosed, 1L);
    }

    public void readFromClient(long bytes) {
        this.inc(this.bytesRead, bytes);
    }

    public void serverStarted() {
    }

    public void updateInjector(Injector injector) {
        MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        this.acceptedConnections = metricRegistry.counter("java-http.accepted-connections");
        this.acceptedRequests = metricRegistry.counter("java-http.accepted-requests");
        this.badRequests = metricRegistry.counter("java-http.bad-requests");
        this.chunkedRequests = metricRegistry.counter("java-http.chunked-requests");
        this.chunkedResponses = metricRegistry.counter("java-http.chunked-responses");
        this.connectionsClosed = metricRegistry.counter("java-http.connections-closed");
        this.bytesRead = metricRegistry.counter("java-http.bytes-read");
        this.bytesWritten = metricRegistry.counter("java-http.bytes-written");
        this.threads = metricRegistry.counter("java-http.running-threads");
    }

    public void workerStarted() {
        this.dec(this.threads, 1L);
    }

    public void workerStopped() {
        this.inc(this.threads, 1L);
    }

    public void wroteToClient(long bytes) {
        this.inc(this.bytesWritten, bytes);
    }

    private void dec(Counter counter, long number) {
        if (counter != null) {
            counter.dec(number);
        }
    }

    private void inc(Counter counter, long number) {
        if (counter != null) {
            counter.inc(number);
        }
    }
}

