/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import java.util.Base64;
import org.example.domain.User;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.testng.annotations.Test;

public class BrowserSessionTest
extends PrimeBaseTest {
    @Test
    public void not_encrypted_cookie() throws Exception {
        this.test.simulate(() -> simulator.test("/browser-session/decrypted").get().assertStatusCode(302).assertRedirect("/browser-session/second").assertContainsCookie("user")).simulate(() -> simulator.test("/browser-session/second").get().assertStatusCode(200).assertBodyContains("The user is missing").assertCookieWasDeleted("user"));
    }

    @Test
    public void compatibility() throws Exception {
        User user = new User();
        user.setName("Brian Pontarelli");
        byte[] byArray = this.objectMapper.writeValueAsBytes((Object)user);
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration));
        byte[] byArray2 = defaultEncryptor.encrypt(byArray);
        String string = Base64.getUrlEncoder().encodeToString(byArray2);
        this.test.simulate(() -> simulator.test("/browser-session/second").withCookie("user", string).get().assertStatusCode(200).assertBodyContains("The user is Brian Pontarelli").assertContainsCookie("user"));
    }

    @Test
    public void sessionCookie() throws Exception {
        this.test.simulate(() -> simulator.test("/browser-session/first").get().assertStatusCode(302).assertRedirect("/browser-session/second").assertContainsCookie("user")).simulate(() -> simulator.test("/browser-session/second").get().assertStatusCode(200).assertBodyContains("The user is Brian Pontarelli").assertContainsCookie("user")).simulate(() -> simulator.test("/browser-session/second").post().assertStatusCode(302).assertRedirect("/browser-session/second").assertCookieWasDeleted("user")).simulate(() -> simulator.test("/browser-session/second").get().assertStatusCode(200).assertBodyContains("The user is missing").assertDoesNotContainsCookie("user"));
    }
}

