/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.json;

import org.primeframework.mvc.json.JSONBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JSONBuilderTest {
    @Test
    public void punctuation() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new JSONBuilder(stringBuilder, false).startObject().startObject("add").startObject("doc").addStringField("id", "id").addStringField("content", "\"hey there\"").addIntField("number", Integer.valueOf(1)).endObject().endObject().endObject().toString();
        Assert.assertEquals((String)string, (String)"{\"add\":{\"doc\":{\"id\":\"id\",\"content\":\"\\\"hey there\\\"\",\"number\":1}}}");
    }

    @Test
    public void simplePretty() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new JSONBuilder(stringBuilder, true).startObject().startObject("add").startObject("doc").addStringField("id", "foo").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).addIntField("numberNull", null).addEnumOrdinalField("enum", (Enum)Status.ACTIVE).addEnumOrdinalField("enumNull", null).addBooleanField("boolean", Boolean.valueOf(true)).addBooleanField("booleanNull", null).endObject().startArray("array").startObject().addStringField("id", "foo").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).endObject().startObject().addStringField("id", "foo").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).endObject().endArray().endObject().endObject().toString();
        Assert.assertEquals((String)string, (String)"{\n  \"add\":{\n    \"doc\":{\n      \"id\":\"foo\",\n      \"content\":\"bar\",\n      \"number\":1,\n      \"enum\":0,\n      \"boolean\":true\n    },\n    \"array\":[\n      {\n        \"id\":\"foo\",\n        \"content\":\"bar\",\n        \"number\":1\n      },\n      {\n        \"id\":\"foo\",\n        \"content\":\"bar\",\n        \"number\":1\n      }\n    ]\n  }\n}");
    }

    @Test
    public void simpleUgly() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new JSONBuilder(stringBuilder, false).startObject().startObject("add").startObject("doc").addStringField("id", "foo").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).endObject().startArray("array").startObject().addStringField("id", "foo").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).endObject().startObject().addStringField("id", "foo").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).endObject().endArray().endObject().endObject().toString();
        Assert.assertEquals((String)string, (String)"{\"add\":{\"doc\":{\"id\":\"foo\",\"content\":\"bar\",\"number\":1},\"array\":[{\"id\":\"foo\",\"content\":\"bar\",\"number\":1},{\"id\":\"foo\",\"content\":\"bar\",\"number\":1}]}}");
    }

    @Test
    public void unicode() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new JSONBuilder(stringBuilder, false).startObject().startObject("add").startObject("doc").addStringField("id", "\u00c3bc").addStringField("content", "bar").addIntField("number", Integer.valueOf(1)).endObject().endObject().endObject().toString();
        Assert.assertEquals((String)string, (String)"{\"add\":{\"doc\":{\"id\":\"\u00c3bc\",\"content\":\"bar\",\"number\":1}}}");
    }

    public static enum Status {
        ACTIVE;

    }
}

