/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPContext;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Set;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.http.HTTPTools;
import org.primeframework.mvc.security.StaticClasspathResourceFilter;
import org.primeframework.mvc.security.StaticResourceFilter;
import org.primeframework.mvc.workflow.Workflow;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceWorkflow
implements Workflow {
    private static final Logger logger = LoggerFactory.getLogger(StaticResourceWorkflow.class);
    private final Set<ClassLoader> additionalClassLoaders;
    private final StaticClasspathResourceFilter classpathResourceFilter;
    private final MVCConfiguration configuration;
    private final HTTPContext context;
    private final HTTPRequest request;
    private final StaticResourceFilter resourceFilter;
    private final HTTPResponse response;

    @Inject
    public StaticResourceWorkflow(HTTPContext context, HTTPRequest request, HTTPResponse response, Set<ClassLoader> additionalClassLoaders, StaticClasspathResourceFilter classpathResourceFilter, MVCConfiguration configuration, StaticResourceFilter resourceFilter) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.additionalClassLoaders = additionalClassLoaders;
        this.classpathResourceFilter = classpathResourceFilter;
        this.configuration = configuration;
        this.resourceFilter = resourceFilter;
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        boolean handled;
        String uri = HTTPTools.getRequestURI(this.request);
        String sanitized = HTTPTools.sanitizeURI(uri);
        if (sanitized == null) {
            logger.debug("Unable to load static resource at uri [{}]", (Object)uri);
            workflowChain.continueWorkflow();
            return;
        }
        try {
            handled = this.findStaticResource(uri, this.request, this.response);
        }
        catch (IOException | RuntimeException e) {
            logger.error("Unable to load static resource at uri [{}]", (Object)uri);
            throw e;
        }
        if (!handled) {
            workflowChain.continueWorkflow();
        }
    }

    protected boolean findStaticResource(String uri, HTTPRequest request, HTTPResponse response) throws IOException {
        String staticDirectory;
        Object file;
        Instant ifModifiedSince = null;
        try {
            ifModifiedSince = request.getDateHeader("If-Modified-Since");
        }
        catch (Exception e) {
            logger.warn("Invalid If-Modified-Since header value [{}], ignoring", (Object)request.getHeader("If-Modified-Since"));
        }
        if (this.resourceFilter.allow(uri, request) && Files.isRegularFile((Path)(file = this.context.resolve((staticDirectory = this.configuration.staticDirectory()) + uri)), new LinkOption[0]) && Files.isReadable((Path)file)) {
            String contentType = Files.probeContentType((Path)file);
            response.setContentType(contentType);
            Instant modified = Files.getLastModifiedTime((Path)file, new LinkOption[0]).toInstant();
            if (ifModifiedSince == null || modified.isAfter(ifModifiedSince)) {
                response.setContentLength(Files.size((Path)file));
                try (InputStream is = Files.newInputStream((Path)file, new OpenOption[0]);){
                    this.writeResponse(response, is, modified);
                }
            } else {
                this.addHeaders(response, modified);
                response.setStatus(304);
            }
            return true;
        }
        if (this.classpathResourceFilter.allow(uri, request)) {
            URL url = HTTPContext.class.getResource(uri);
            if (url == null) {
                ClassLoader classLoader;
                file = this.additionalClassLoaders.iterator();
                while (file.hasNext() && (url = (classLoader = (ClassLoader)file.next()).getResource(uri)) == null) {
                }
            }
            if (url != null) {
                URLConnection connection = url.openConnection();
                response.setContentType(connection.getContentType());
                Instant modified = Instant.ofEpochMilli(connection.getLastModified());
                if (ifModifiedSince == null || modified.isAfter(ifModifiedSince)) {
                    long length = connection.getContentLengthLong();
                    if (length > 0L) {
                        response.setContentLength(length);
                    }
                    try (InputStream is = connection.getInputStream();){
                        this.writeResponse(response, is, modified);
                    }
                } else {
                    this.addHeaders(response, modified);
                    response.setStatus(304);
                }
                return true;
            }
        }
        return false;
    }

    private void addHeaders(HTTPResponse response, Instant modified) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime expiry = now.plusDays(7L);
        response.setHeader("Cache-Control", "public");
        response.setDateHeader("Date", now);
        response.setDateHeader("Expires", expiry);
        response.setDateHeader("Last-Modified", ZonedDateTime.ofInstant(modified, ZoneOffset.UTC));
        response.setDateHeader("Retry-After", expiry);
    }

    private void writeResponse(HTTPResponse response, InputStream is, Instant modified) throws IOException {
        this.addHeaders(response, modified);
        response.setStatus(200);
        is.transferTo(response.getOutputStream());
    }
}

