/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.workflow.ExceptionHandler;
import org.primeframework.mvc.workflow.TypedExceptionHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionHandler
implements ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    private final MVCConfiguration configuration;
    private final TypedExceptionHandlerFactory factory;
    private final HTTPResponse response;
    private final ResultStore resultStore;

    @Inject
    public DefaultExceptionHandler(MVCConfiguration configuration, TypedExceptionHandlerFactory factory, HTTPResponse response, ResultStore resultStore) {
        this.configuration = configuration;
        this.factory = factory;
        this.response = response;
        this.resultStore = resultStore;
    }

    @Override
    public void handle(Throwable exception) {
        this.response.setException(exception);
        for (Class<?> klass = exception.getClass(); klass != Throwable.class; klass = klass.getSuperclass()) {
            Object handler = this.factory.build(klass);
            if (handler == null) {
                continue;
            }
            handler.handle((Throwable)exception);
            return;
        }
        logger.error("Unhandled exception occurred", exception);
        this.resultStore.set(this.configuration.exceptionResultCode());
        this.response.setStatus(500);
    }
}

