/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.jwt.JWTExpiredException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.json.JacksonModule;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.http.FormBodyPublisher;
import org.primeframework.mvc.security.CookieProxy;
import org.primeframework.mvc.security.InvalidLoginContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.VerifierProvider;
import org.primeframework.mvc.security.oauth.OAuthConfiguration;
import org.primeframework.mvc.security.oauth.RefreshResponse;
import org.primeframework.mvc.security.oauth.TokenAuthenticationMethod;
import org.primeframework.mvc.security.oauth.Tokens;
import org.primeframework.mvc.util.ObjectTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJWTRefreshTokenCookiesUserLoginSecurityContext
implements UserLoginSecurityContext {
    private static final String ContextKey = "primeLoginContext";
    private static final String UserKey = "primeCurrentUser";
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final Logger log = LoggerFactory.getLogger(BaseJWTRefreshTokenCookiesUserLoginSecurityContext.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JacksonModule());
    protected final CookieProxy jwtCookie;
    protected final CookieProxy refreshTokenCookie;
    protected final HTTPRequest request;
    protected final HTTPResponse response;
    protected final VerifierProvider verifierProvider;

    protected BaseJWTRefreshTokenCookiesUserLoginSecurityContext(HTTPRequest request, HTTPResponse response, VerifierProvider verifierProvider) {
        this.request = request;
        this.response = response;
        this.verifierProvider = verifierProvider;
        this.jwtCookie = new CookieProxy(this.jwtCookieName(), (Long)Integer.MAX_VALUE, this.cookieSameSite());
        this.refreshTokenCookie = new CookieProxy(this.refreshTokenCookieName(), (Long)Integer.MAX_VALUE, this.cookieSameSite());
    }

    @Override
    public Object getCurrentUser() {
        Object user = this.request.getAttribute(UserKey);
        if (user != null) {
            return user;
        }
        Tokens tokens = this.resolveContext();
        if (tokens.jwt == null) {
            return null;
        }
        user = this.retrieveUserForJWT(tokens.decodedJWT, tokens.jwt);
        if (user == null) {
            this.jwtCookie.delete(this.request, this.response);
        } else {
            this.request.setAttribute(UserKey, user);
        }
        return user;
    }

    @Override
    public String getSessionId() {
        Tokens tokens = this.resolveContext();
        if (tokens.decodedJWT != null) {
            return tokens.decodedJWT.getString("sid");
        }
        return null;
    }

    @Override
    public boolean isLoggedIn() {
        return this.getCurrentUser() != null;
    }

    @Override
    public void login(Object context) {
        if (!(context instanceof Tokens)) {
            throw new IllegalArgumentException("The login context for [BaseJWTRefreshTokenCookiesUserLoginSecurityContext] is expected to be of type [" + Tokens.class.getCanonicalName() + "] but an object of type [" + context.getClass().getCanonicalName() + "] was provided. This is a development time error.");
        }
        Tokens tokens = (Tokens)context;
        try {
            if (tokens.jwt != null) {
                Map<String, Verifier> verifiers = this.getVerifiersOrNull();
                if (verifiers == null) {
                    return;
                }
                tokens.decodedJWT = JWT.getDecoder().decode(tokens.jwt, verifiers);
                if (!this.validateJWTClaims(tokens.decodedJWT)) {
                    this.invalidateSession(tokens);
                    throw new InvalidLoginContext();
                }
                this.jwtCookie.add(this.request, this.response, tokens.jwt);
            }
            if (tokens.refreshToken != null) {
                this.refreshTokenCookie.add(this.request, this.response, tokens.refreshToken);
            }
        }
        catch (Exception e) {
            this.invalidateSession(tokens);
            throw new InvalidLoginContext();
        }
    }

    @Override
    public void logout() {
        this.jwtCookie.delete(this.request, this.response);
        this.refreshTokenCookie.delete(this.request, this.response);
    }

    @Override
    public void updateUser(Object user) {
        Object currentUser = this.request.getAttribute(UserKey);
        if (currentUser != null) {
            this.request.setAttribute(UserKey, user);
        }
    }

    protected Cookie.SameSite cookieSameSite() {
        return Cookie.SameSite.Strict;
    }

    protected boolean isRevoked(JWT jwt) {
        return false;
    }

    protected abstract String jwtCookieName();

    protected abstract OAuthConfiguration oauthConfiguration();

    protected abstract String refreshTokenCookieName();

    protected abstract Object retrieveUserForJWT(JWT var1, String var2);

    protected boolean validateJWTClaims(JWT jwt) {
        return true;
    }

    private Map<String, Verifier> getVerifiersOrNull() {
        Map<String, Verifier> verifiers = this.verifierProvider.get();
        return verifiers.isEmpty() ? null : verifiers;
    }

    private Tokens invalidateSession(Tokens tokens) {
        tokens.decodedJWT = null;
        tokens.jwt = null;
        tokens.refreshToken = null;
        this.jwtCookie.delete(this.request, this.response);
        this.refreshTokenCookie.delete(this.request, this.response);
        return tokens;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Tokens refreshJWT(Tokens tokens) {
        HttpResponse<InputStream> httpResponse;
        tokens.jwt = null;
        tokens.decodedJWT = null;
        if (tokens.refreshToken == null) {
            this.jwtCookie.delete(this.request, this.response);
            return tokens;
        }
        HashMap<String, List<String>> body = new HashMap<String, List<String>>(2);
        body.put("grant_type", List.of("refresh_token"));
        body.put("refresh_token", List.of(tokens.refreshToken));
        OAuthConfiguration oauthConfiguration = this.oauthConfiguration();
        if (oauthConfiguration == null) {
            return tokens;
        }
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(oauthConfiguration.tokenEndpoint));
        if (oauthConfiguration.authenticationMethod == TokenAuthenticationMethod.client_secret_basic) {
            if (oauthConfiguration.clientId.contains(":")) {
                return this.invalidateSession(tokens);
            }
            String encoded = Base64.getEncoder().encodeToString((oauthConfiguration.clientId + ":" + oauthConfiguration.clientSecret).getBytes(StandardCharsets.UTF_8));
            requestBuilder.header("Authorization", "Basic " + encoded);
        } else if (oauthConfiguration.authenticationMethod == TokenAuthenticationMethod.client_secret_post) {
            body.put("client_id", List.of(oauthConfiguration.clientId));
            body.put("client_secret", List.of(oauthConfiguration.clientSecret));
        }
        body.putAll(oauthConfiguration.additionalParameters);
        HttpRequest refreshRequest = requestBuilder.header("Content-Type", "application/x-www-form-urlencoded").POST(new FormBodyPublisher(body)).build();
        try {
            httpResponse = httpClient.send(refreshRequest, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (Exception e) {
            log.error("Unable to refresh refresh token", (Throwable)e);
            return this.invalidateSession(tokens);
        }
        try (InputStream responseBody = httpResponse.body();){
            if (httpResponse.statusCode() < 200 || httpResponse.statusCode() > 299) {
                Tokens tokens2 = this.invalidateSession(tokens);
                return tokens2;
            }
            RefreshResponse rr = (RefreshResponse)objectMapper.readValue(responseBody, RefreshResponse.class);
            tokens.jwt = rr.access_token;
            tokens.refreshToken = ObjectTools.defaultIfNull(rr.refresh_token, tokens.refreshToken);
        }
        catch (IOException e) {
            log.error("Unable to parse refresh token response", (Throwable)e);
            return this.invalidateSession(tokens);
        }
        Map<String, Verifier> verifiers = this.getVerifiersOrNull();
        if (verifiers != null) {
            tokens.decodedJWT = JWT.getDecoder().decode(tokens.jwt, verifiers);
            if (!this.validateJWTClaims(tokens.decodedJWT)) {
                this.invalidateSession(tokens);
                return tokens;
            }
        }
        if (tokens.jwt != null) {
            this.jwtCookie.add(this.request, this.response, tokens.jwt);
        }
        if (tokens.refreshToken == null) return tokens;
        this.refreshTokenCookie.add(this.request, this.response, tokens.refreshToken);
        return tokens;
    }

    private Tokens resolveContext() {
        Tokens tokens = (Tokens)this.request.getAttribute(ContextKey);
        if (tokens != null) {
            return tokens;
        }
        tokens = new Tokens();
        this.request.setAttribute(ContextKey, (Object)tokens);
        Map<String, Verifier> verifiers = this.getVerifiersOrNull();
        if (verifiers == null) {
            return tokens;
        }
        tokens.jwt = this.jwtCookie.get(this.request);
        tokens.refreshToken = this.refreshTokenCookie.get(this.request);
        if (tokens.jwt == null && tokens.refreshToken == null) {
            return tokens;
        }
        try {
            if (tokens.jwt == null) {
                return this.refreshJWT(tokens);
            }
            tokens.decodedJWT = JWT.getDecoder().decode(tokens.jwt, verifiers);
            if (!this.validateJWTClaims(tokens.decodedJWT) || this.isRevoked(tokens.decodedJWT)) {
                this.invalidateSession(tokens);
                return tokens;
            }
            return tokens;
        }
        catch (JWTExpiredException e) {
            return this.refreshJWT(tokens);
        }
        catch (Exception e) {
            this.invalidateSession(tokens);
            return tokens;
        }
    }
}

