/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.scope;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.scope.Scope;

public abstract class AbstractCookieScope<T extends Annotation>
implements Scope<T> {
    protected final HTTPRequest request;
    protected final HTTPResponse response;

    protected AbstractCookieScope(HTTPRequest request, HTTPResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public Object get(String fieldName, Class<?> type, T scope) {
        String cookieName = this.getCookieName(fieldName, scope);
        Cookie cookie = this.request.getCookie(cookieName);
        return this.processCookie(cookie, fieldName, type, scope);
    }

    @Override
    public void set(String fieldName, Object value, T scope) {
        Cookie cookie = this.buildCookie(fieldName, value, scope);
        if (cookie != null) {
            cookie.httpOnly = true;
            cookie.path = "/";
            cookie.secure = "https".equalsIgnoreCase(this.request.getScheme());
            this.response.addCookie(cookie);
        } else {
            String cookieName = this.getCookieName(fieldName, scope);
            if (this.request.getCookie(cookieName) == null) {
                return;
            }
            this.response.removeCookie(cookieName);
            cookie = new Cookie(cookieName, null);
            cookie.maxAge = 0L;
            cookie.path = "/";
            this.response.addCookie(cookie);
        }
    }

    protected abstract Cookie buildCookie(String var1, Object var2, T var3);

    protected abstract String getCookieName(String var1, T var2);

    protected abstract Object processCookie(Cookie var1, String var2, Class<?> var3, T var4);
}

