/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.MultipleParametersUnsupportedException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;

@GlobalConverter
public class UUIDConverter
extends AbstractGlobalConverter {
    private final boolean emptyIsNull;

    @Inject
    public UUIDConverter(MVCConfiguration configuration) {
        this.emptyIsNull = configuration.emptyParametersAreNull();
    }

    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        UUID uuid = (UUID)value;
        if (uuid.getMostSignificantBits() == 0L) {
            return Long.toString(uuid.getLeastSignificantBits());
        }
        return value.toString();
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        if (this.emptyIsNull && StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException iae) {
            try {
                long l = Long.parseLong(value);
                return new UUID(0L, l);
            }
            catch (NumberFormatException e) {
                throw new ConversionException();
            }
        }
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        throw new MultipleParametersUnsupportedException("You are attempting to map a form field that contains multiple parameters to a property on the action class that is of type UUID. This isn't allowed.");
    }
}

