/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.parameter.URIParameterWorkflow;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultURIParameterWorkflow
implements URIParameterWorkflow {
    private final ActionInvocationStore actionInvocationStore;
    private final HTTPRequest request;

    @Inject
    public DefaultURIParameterWorkflow(HTTPRequest request, ActionInvocationStore actionInvocationStore) {
        this.request = request;
        this.actionInvocationStore = actionInvocationStore;
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        if (actionInvocation.uriParameters.size() > 0) {
            Map<String, List<String>> params = actionInvocation.uriParameters;
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                this.request.getParameters().putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        workflowChain.continueWorkflow();
    }
}

