/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import freemarker.cache.TemplateLoader;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.core.TemplateClassResolver;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Version;
import org.primeframework.mvc.config.MVCConfiguration;

public class FreeMarkerConfigurationProvider
implements Provider<Configuration> {
    private final MVCConfiguration configuration;
    private final TemplateLoader loader;

    @Inject
    public FreeMarkerConfigurationProvider(MVCConfiguration configuration, TemplateLoader loader) {
        this.configuration = configuration;
        this.loader = loader;
    }

    public Configuration get() {
        Version incompatibleImprovements = this.incompatibleImprovementsVersion();
        BeansWrapperBuilder builder = new BeansWrapperBuilder(incompatibleImprovements);
        builder.setExposeFields(true);
        builder.setSimpleMapWrapper(true);
        int checkSeconds = this.configuration.templateCheckSeconds();
        Configuration config = new Configuration(incompatibleImprovements);
        config.setTagSyntax(2);
        config.setTemplateUpdateDelayMilliseconds((long)checkSeconds * 1000L);
        config.setTemplateLoader(this.loader);
        config.setDefaultEncoding("UTF-8");
        config.setObjectWrapper((ObjectWrapper)builder.build());
        config.setNumberFormat("computer");
        if (this.configuration.autoHTMLEscapingEnabled()) {
            config.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
        }
        config.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
        config.setAPIBuiltinEnabled(false);
        return config;
    }

    protected Version incompatibleImprovementsVersion() {
        return Configuration.VERSION_2_3_32;
    }
}

