/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.guice;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import org.primeframework.mvc.action.config.ActionConfigurator;
import org.primeframework.mvc.content.ContentWorkflow;
import org.primeframework.mvc.content.DefaultContentHandler;
import org.primeframework.mvc.content.DefaultContentWorkflow;
import org.primeframework.mvc.content.ServerHandledContentHandler;
import org.primeframework.mvc.content.binary.BinaryActionConfigurator;
import org.primeframework.mvc.content.binary.BinaryContentHandler;
import org.primeframework.mvc.content.guice.ContentHandlerFactory;
import org.primeframework.mvc.content.guice.ObjectMapperProvider;
import org.primeframework.mvc.content.json.JacksonActionConfigurator;
import org.primeframework.mvc.content.json.JacksonContentHandler;
import org.primeframework.mvc.content.json.JacksonPatchContentHandler;

public class ContentModule
extends AbstractModule {
    protected void bindContentHandlers() {
        ContentHandlerFactory.addContentHandler(this.binder(), "application/json", JacksonContentHandler.class);
        ContentHandlerFactory.addContentHandler(this.binder(), "application/json-patch+json", JacksonPatchContentHandler.class);
        ContentHandlerFactory.addContentHandler(this.binder(), "application/merge-patch+json", JacksonPatchContentHandler.class);
        ContentHandlerFactory.addContentHandler(this.binder(), "application/octet-stream", BinaryContentHandler.class);
        ContentHandlerFactory.addContentHandler(this.binder(), "multipart/form-data", ServerHandledContentHandler.class);
        ContentHandlerFactory.addContentHandler(this.binder(), "application/x-www-form-urlencoded", ServerHandledContentHandler.class);
        ContentHandlerFactory.addContentHandler(this.binder(), "", DefaultContentHandler.class);
        Multibinder multiBinder = Multibinder.newSetBinder((Binder)this.binder(), ActionConfigurator.class);
        multiBinder.addBinding().to(JacksonActionConfigurator.class);
        multiBinder.addBinding().to(BinaryActionConfigurator.class);
        Multibinder.newSetBinder((Binder)this.binder(), Module.class);
        this.bindObjectMapper();
    }

    protected void bindObjectMapper() {
        this.bind(ObjectMapper.class).toProvider(ObjectMapperProvider.class).asEagerSingleton();
    }

    protected void configure() {
        this.bind(ContentWorkflow.class).to(DefaultContentWorkflow.class);
        this.bind(ContentHandlerFactory.class);
        this.bindContentHandlers();
    }
}

