/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractRedirectResult;
import org.primeframework.mvc.action.result.SavedRequestTools;
import org.primeframework.mvc.action.result.annotation.ReexecuteSavedRequest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.security.Encryptor;

public class ReexecuteSavedRequestResult
extends AbstractRedirectResult<ReexecuteSavedRequest> {
    private final MVCConfiguration configuration;
    private final Encryptor encryptor;
    private final ObjectMapper objectMapper;

    @Inject
    public ReexecuteSavedRequestResult(MessageStore messageStore, ExpressionEvaluator expressionEvaluator, HTTPResponse response, HTTPRequest request, ActionInvocationStore actionInvocationStore, MVCConfiguration configuration, Encryptor encryptor, ObjectMapper objectMapper) {
        super(expressionEvaluator, actionInvocationStore, messageStore, request, response);
        this.configuration = configuration;
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean execute(ReexecuteSavedRequest reexecuteSavedRequest) throws IOException {
        this.moveMessagesToFlash();
        SavedRequestTools.SaveHttpRequestResult result = SavedRequestTools.getSaveRequestForReExecution(this.configuration, this.encryptor, this.objectMapper, this.request, this.response);
        String uri = result != null && result.savedHttpRequest.uri != null ? result.savedHttpRequest.uri : null;
        this.addCacheControlHeader(reexecuteSavedRequest, this.response);
        this.sendRedirect(uri, reexecuteSavedRequest.uri(), reexecuteSavedRequest.encodeVariables(), reexecuteSavedRequest.perm());
        return true;
    }

    @Override
    protected String getCacheControl(ReexecuteSavedRequest result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(ReexecuteSavedRequest result) {
        return result.disableCacheControl();
    }

    public static class ReexecuteSavedRequestImpl
    implements ReexecuteSavedRequest {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final boolean encode;
        private final boolean perm;
        private final String uri;

        public ReexecuteSavedRequestImpl(String uri, String code, boolean perm, boolean encode) {
            this.cacheControl = "no-cache";
            this.code = code;
            this.disableCacheControl = false;
            this.encode = encode;
            this.perm = perm;
            this.uri = uri;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ReexecuteSavedRequest.class;
        }

        @Override
        public String cacheControl() {
            return this.cacheControl;
        }

        @Override
        public String code() {
            return this.code;
        }

        @Override
        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        @Override
        public boolean encodeVariables() {
            return this.encode;
        }

        @Override
        public boolean perm() {
            return this.perm;
        }

        @Override
        public String uri() {
            return this.uri;
        }
    }
}

