/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.config;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.jwt.domain.JWT;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.AuthorizationMethodConfiguration;
import org.primeframework.mvc.action.ConstraintOverrideMethodConfiguration;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.JWTMethodConfiguration;
import org.primeframework.mvc.action.PreParameterMethodConfiguration;
import org.primeframework.mvc.action.ValidationMethodConfiguration;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.annotation.AllowUnknownParameters;
import org.primeframework.mvc.action.annotation.AlternateMessageResources;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.ActionConfigurationBuilder;
import org.primeframework.mvc.action.config.ActionConfigurator;
import org.primeframework.mvc.action.result.annotation.ResultAnnotation;
import org.primeframework.mvc.action.result.annotation.ResultContainerAnnotation;
import org.primeframework.mvc.content.ValidContentTypes;
import org.primeframework.mvc.control.form.annotation.FormPrepareMethod;
import org.primeframework.mvc.parameter.annotation.PostParameterMethod;
import org.primeframework.mvc.parameter.annotation.PreParameter;
import org.primeframework.mvc.parameter.annotation.PreParameterMethod;
import org.primeframework.mvc.parameter.annotation.PreRenderMethod;
import org.primeframework.mvc.parameter.annotation.UnknownParameters;
import org.primeframework.mvc.parameter.fileupload.annotation.FileUpload;
import org.primeframework.mvc.scope.ScopeField;
import org.primeframework.mvc.scope.annotation.ScopeAnnotation;
import org.primeframework.mvc.security.AuthorizeSchemeData;
import org.primeframework.mvc.security.annotation.AnonymousAccess;
import org.primeframework.mvc.security.annotation.AuthorizeMethod;
import org.primeframework.mvc.security.annotation.ConstraintOverrideMethod;
import org.primeframework.mvc.security.annotation.JWTAuthorizeMethod;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.util.URIBuilder;
import org.primeframework.mvc.validation.Validation;
import org.primeframework.mvc.validation.ValidationMethod;
import org.primeframework.mvc.validation.annotation.PostValidationMethod;
import org.primeframework.mvc.validation.annotation.PreValidationMethod;

public class DefaultActionConfigurationBuilder
implements ActionConfigurationBuilder {
    private final Set<ActionConfigurator> configurators;
    private final URIBuilder uriBuilder;

    @Inject
    public DefaultActionConfigurationBuilder(URIBuilder uriBuilder, Set<ActionConfigurator> configurators) {
        this.uriBuilder = uriBuilder;
        this.configurators = configurators;
    }

    @Override
    public ActionConfiguration build(Class<?> actionClass) {
        if ((actionClass.getModifiers() & 0x400) != 0) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] is annotated with the @Action annotation but is abstract. You can only annotate concrete action classes");
        }
        Action action = actionClass.getAnnotation(Action.class);
        String uri = !action.baseURI().equals("") ? action.baseURI() : this.uriBuilder.build(actionClass);
        boolean allowKnownParameters = actionClass.getAnnotation(AllowUnknownParameters.class) != null;
        Map<HTTPMethod, ExecuteMethodConfiguration> executeMethods = this.findExecuteMethods(actionClass);
        List<Method> formPrepareMethods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, FormPrepareMethod.class);
        List<Method> postParameterMethods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, PostParameterMethod.class);
        Map<Class<?>, List<Method>> preRenderMethodsMap = this.findAllPreRenderMethods(actionClass);
        List<Method> preValidationMethods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, PreValidationMethod.class);
        List<Method> postValidationMethods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, PostValidationMethod.class);
        Map<String, Annotation> resultAnnotations = this.findResultConfigurations(actionClass);
        Map<String, PreParameter> preParameterMembers = ReflectionUtils.findAllMembersWithAnnotation(actionClass, PreParameter.class);
        Map<String, FileUpload> fileUploadMembers = ReflectionUtils.findAllMembersWithAnnotation(actionClass, FileUpload.class);
        Set<String> memberNames = ReflectionUtils.findAllMembers(actionClass);
        Map<HTTPMethod, List<PreParameterMethodConfiguration>> preParameterMethods = this.findAnnotatedMethods(actionClass, PreParameterMethod.class, (annotation, method) -> new PreParameterMethodConfiguration((Method)method, (PreParameterMethod)annotation), config -> Arrays.stream(config.annotation.httpMethods()).map(HTTPMethod::of).collect(Collectors.toList()));
        Map<HTTPMethod, List<ValidationMethodConfiguration>> validationMethods = this.findAnnotatedMethods(actionClass, ValidationMethod.class, (annotation, method) -> new ValidationMethodConfiguration((Method)method, (ValidationMethod)annotation), config -> Arrays.stream(config.annotation.httpMethods()).map(HTTPMethod::of).collect(Collectors.toList()));
        List<String> securitySchemes = this.findSecuritySchemes(actionClass);
        Map<HTTPMethod, List<AuthorizationMethodConfiguration>> authorizationMethods = this.findAuthorizationMethods(actionClass, securitySchemes, executeMethods);
        Map<HTTPMethod, List<JWTMethodConfiguration>> jwtAuthorizationMethods = this.findJwtAuthorizationMethods(actionClass, securitySchemes, executeMethods);
        List<ScopeField> scopeFields = this.findScopeFields(actionClass);
        Map<Class<?>, Object> additionalConfiguration = this.getAdditionalConfiguration(actionClass);
        Map<HTTPMethod, ConstraintOverrideMethodConfiguration> constraintValidationMethods = this.findConstraintValidationMethod(actionClass);
        Field unknownParametersField = this.findUnknownParametersField(actionClass);
        Set<String> validContentTypes = this.findAllowedContentTypes(actionClass);
        List<String> alternateMessageURIs = Optional.ofNullable(actionClass.getAnnotation(AlternateMessageResources.class)).map(alternate -> Arrays.stream(alternate.actions()).map(this.uriBuilder::build).toList()).orElse(List.of());
        return new ActionConfiguration(actionClass, allowKnownParameters, constraintValidationMethods, executeMethods, validationMethods, formPrepareMethods, authorizationMethods, jwtAuthorizationMethods, postValidationMethods, preParameterMethods, postParameterMethods, resultAnnotations, preParameterMembers, preRenderMethodsMap, fileUploadMembers, memberNames, securitySchemes, scopeFields, additionalConfiguration, uri, preValidationMethods, unknownParametersField, validContentTypes, alternateMessageURIs);
    }

    protected void addResultConfiguration(Class<?> actionClass, Map<String, Annotation> resultConfigurations, Annotation annotation, Class<? extends Annotation> annotationType) {
        try {
            String code = (String)annotation.getClass().getMethod("code", new Class[0]).invoke((Object)annotation, new Object[0]);
            if (resultConfigurations.containsKey(code)) {
                throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] contains two or more result annotations for the code [" + code + "]");
            }
            resultConfigurations.put(code, annotation);
        }
        catch (NoSuchMethodException e) {
            throw new PrimeException("The result annotation [" + String.valueOf(annotationType) + "] is missing a method named [code] that returns a String. For example:\n\npublic @interface MyResult {\n  String code() default \"success\";\n}", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PrimeException("Unable to invoke the code() method on the result annotation container [" + String.valueOf(annotationType) + "]", e);
        }
    }

    protected Map<String, Annotation> addResultsForClass(Class<?> actionClass) {
        Annotation[] annotations;
        HashMap<String, Annotation> resultConfigurations = new HashMap<String, Annotation>();
        for (Annotation annotation : annotations = actionClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            ResultAnnotation resultAnnotation = annotationType.getAnnotation(ResultAnnotation.class);
            if (resultAnnotation != null) {
                this.addResultConfiguration(actionClass, resultConfigurations, annotation, annotationType);
                continue;
            }
            if (!annotationType.isAnnotationPresent(ResultContainerAnnotation.class)) continue;
            try {
                Annotation[] results;
                for (Annotation result : results = (Annotation[])annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0])) {
                    annotationType = result.annotationType();
                    this.addResultConfiguration(actionClass, resultConfigurations, result, annotationType);
                }
            }
            catch (NoSuchMethodException e) {
                throw new PrimeException("The result annotation container [" + String.valueOf(annotationType) + "] must have a method named [value] that is an array of result annotations. For example:\n\npublic @interface MyContainer {\n  MyResult[] value();\n}", e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new PrimeException("Unable to invoke the value() method on the result annotation container [" + String.valueOf(annotationType) + "]", e);
            }
        }
        return resultConfigurations;
    }

    protected Set<String> findAllowedContentTypes(Class<?> actionClass) {
        Class<?> currentClass = actionClass;
        while (!currentClass.equals(Object.class)) {
            ValidContentTypes annotation = currentClass.getAnnotation(ValidContentTypes.class);
            if (annotation != null) {
                return Set.of(annotation.value());
            }
            currentClass = currentClass.getSuperclass();
        }
        return Set.of();
    }

    protected <T extends Annotation, U> Map<HTTPMethod, List<U>> findAnnotatedMethods(Class<?> actionClass, Class<T> annotationType, BiFunction<T, Method, U> constructor, Function<U, List<HTTPMethod>> methodFunction) {
        List<Method> methods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, annotationType);
        HashMap map = new HashMap();
        methods.stream().map(m -> constructor.apply(m.getAnnotation(annotationType), (Method)m)).forEach(c -> ((List)methodFunction.apply(c)).forEach(m -> map.computeIfAbsent((HTTPMethod)m, k -> new ArrayList()).add(c)));
        if (map.containsKey(HTTPMethod.GET) && !map.containsKey(HTTPMethod.HEAD)) {
            map.put(HTTPMethod.HEAD, (List)map.get(HTTPMethod.GET));
        }
        return map;
    }

    protected Map<HTTPMethod, List<AuthorizationMethodConfiguration>> findAuthorizationMethods(Class<?> actionClass, List<String> securitySchemes, Map<HTTPMethod, ExecuteMethodConfiguration> executeMethods) {
        if (!securitySchemes.contains("authorize-method")) {
            return Collections.emptyMap();
        }
        List<Method> methods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, AuthorizeMethod.class);
        if (methods.isEmpty()) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] is missing at a Authorization method. The class must define a one or more methods annotated " + AuthorizeMethod.class.getSimpleName() + " when the [authorize-method] is specified as a security scheme.");
        }
        if (methods.stream().anyMatch(m -> m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has at least one Authorization method that has declared a return type of something other than boolean. Your method annotated with " + AuthorizeMethod.class.getSimpleName() + " must declare a return typeof boolean or Boolean.");
        }
        if (methods.stream().anyMatch(m -> m.getParameterCount() > 1)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has at least one Authorization method that has not declared the correct method signature. Your method annotated with " + AuthorizeMethod.class.getSimpleName() + " may be declared without parameters, or a single parameter of type " + AuthorizeSchemeData.class.getSimpleName() + ".");
        }
        if (methods.stream().filter(m -> m.getParameterCount() == 1).anyMatch(m -> m.getParameterTypes()[0] != AuthorizeSchemeData.class)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has at least one Authorization method that has not declared the correct method signature. Your method annotated with " + AuthorizeMethod.class.getSimpleName() + " must declare a single method parameter of type " + AuthorizeSchemeData.class.getSimpleName() + ".");
        }
        HashMap<HTTPMethod, List<AuthorizationMethodConfiguration>> authorizationMethods = new HashMap<HTTPMethod, List<AuthorizationMethodConfiguration>>();
        methods.stream().map(m -> new AuthorizationMethodConfiguration((Method)m, m.getAnnotation(AuthorizeMethod.class))).forEach(c -> Arrays.stream(c.annotation.httpMethods()).map(HTTPMethod::of).collect(Collectors.toList()).forEach(m -> authorizationMethods.computeIfAbsent((HTTPMethod)m, k -> new ArrayList()).add(c)));
        if (authorizationMethods.containsKey(HTTPMethod.GET) && !authorizationMethods.containsKey(HTTPMethod.HEAD)) {
            authorizationMethods.put(HTTPMethod.HEAD, (List)authorizationMethods.get(HTTPMethod.GET));
        }
        Set authenticatedMethods = executeMethods.keySet().stream().filter(k -> {
            ExecuteMethodConfiguration methodConfiguration = (ExecuteMethodConfiguration)executeMethods.get(k);
            return methodConfiguration.annotations.containsKey(AnonymousAccess.class);
        }).collect(Collectors.toSet());
        if (!authorizationMethods.keySet().containsAll(authenticatedMethods)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] is missing at an Authorization method. The class must define one or more methods annotated " + AuthorizeMethod.class.getSimpleName() + " when the [authorize-method] is specified as a security scheme. Ensure that for each execute method in your action such as post, put, get and delete that a method is configured to authorize the request.");
        }
        return authorizationMethods;
    }

    protected Map<HTTPMethod, ConstraintOverrideMethodConfiguration> findConstraintValidationMethod(Class<?> actionClass) {
        List<Method> methods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, ConstraintOverrideMethod.class);
        if (methods.isEmpty()) {
            return Collections.emptyMap();
        }
        if (methods.stream().anyMatch(m -> !Collection.class.isAssignableFrom(m.getReturnType()))) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has at least one method annotated with " + ConstraintOverrideMethod.class.getSimpleName() + " that has a declared a return type of something other than Collection<?>. Your method annotated with " + ConstraintOverrideMethod.class.getSimpleName() + " must declare a return type of Collection<T>.");
        }
        HashMap<HTTPMethod, ConstraintOverrideMethodConfiguration> constraintOverrideMethods = new HashMap<HTTPMethod, ConstraintOverrideMethodConfiguration>();
        for (Method method : methods) {
            ConstraintOverrideMethod annotation = method.getAnnotation(ConstraintOverrideMethod.class);
            for (String stringMethod : annotation.httpMethods()) {
                HTTPMethod httpMethod = HTTPMethod.of((String)stringMethod);
                if (constraintOverrideMethods.containsKey(httpMethod)) {
                    throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has more than one method annotated with " + ConstraintOverrideMethod.class.getSimpleName() + " for the same HTTP method. You may only have one method annotated " + ConstraintOverrideMethod.class.getSimpleName() + " for any one HTTP method.");
                }
                constraintOverrideMethods.put(httpMethod, new ConstraintOverrideMethodConfiguration(method, annotation));
            }
        }
        return constraintOverrideMethods;
    }

    protected Map<HTTPMethod, ExecuteMethodConfiguration> findExecuteMethods(Class<?> actionClass) {
        Method defaultMethod = null;
        try {
            defaultMethod = actionClass.getMethod("execute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HashMap<HTTPMethod, ExecuteMethodConfiguration> executeMethods = new HashMap<HTTPMethod, ExecuteMethodConfiguration>();
        for (HTTPMethod httpMethod : HTTPMethod.StandardMethods.values()) {
            Method method = null;
            try {
                method = actionClass.getMethod(httpMethod.name().toLowerCase(), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null && HTTPMethod.HEAD.is(httpMethod)) {
                try {
                    method = actionClass.getMethod("get", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                method = defaultMethod;
            }
            if (method == null) continue;
            this.verify(method);
            executeMethods.put(httpMethod, new ExecuteMethodConfiguration(httpMethod, method, method.getAnnotation(Validation.class)));
        }
        if (executeMethods.isEmpty()) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] is missing at least one valid execute method. The class can define execute methods with the same names as the HTTP methods (lowercased) or a default execute method named [execute]. For example:\n\npublic String execute() {\n  return \"success\"\n}\n\nor\n\npublic String post() {\n  return \"success\"\n}");
        }
        return executeMethods;
    }

    protected Map<HTTPMethod, List<JWTMethodConfiguration>> findJwtAuthorizationMethods(Class<?> actionClass, List<String> securitySchemes, Map<HTTPMethod, ExecuteMethodConfiguration> executeMethods) {
        if (securitySchemes.stream().noneMatch(s -> s.contains("jwt"))) {
            return Collections.emptyMap();
        }
        List<Method> methods = ReflectionUtils.findAllMethodsWithAnnotation(actionClass, JWTAuthorizeMethod.class);
        if (methods.stream().anyMatch(m -> m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has at least one JWT Authorization method that has declared a return type of something other than boolean. Your method annotated with " + JWTAuthorizeMethod.class.getSimpleName() + " must declare a return typeof boolean or Boolean.");
        }
        if (methods.stream().anyMatch(m -> m.getParameterCount() != 1 || m.getParameterTypes()[0] != JWT.class)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has at least one JWT Authorization method that has not declared the correct method signature. Your method annotated with " + JWTAuthorizeMethod.class.getSimpleName() + " must declare a single method parameter of type JWT.");
        }
        HashMap<HTTPMethod, List<JWTMethodConfiguration>> jwtMethods = new HashMap<HTTPMethod, List<JWTMethodConfiguration>>();
        methods.stream().map(m -> new JWTMethodConfiguration((Method)m, m.getAnnotation(JWTAuthorizeMethod.class))).forEach(c -> Arrays.stream(c.annotation.httpMethods()).map(HTTPMethod::of).collect(Collectors.toList()).forEach(m -> jwtMethods.computeIfAbsent((HTTPMethod)m, k -> new ArrayList()).add(c)));
        if (jwtMethods.containsKey(HTTPMethod.GET) && !jwtMethods.containsKey(HTTPMethod.HEAD)) {
            jwtMethods.put(HTTPMethod.HEAD, (List)jwtMethods.get(HTTPMethod.GET));
        }
        Set authenticatedMethods = executeMethods.keySet().stream().filter(k -> {
            ExecuteMethodConfiguration methodConfiguration = (ExecuteMethodConfiguration)executeMethods.get(k);
            return methodConfiguration.annotations.containsKey(AnonymousAccess.class);
        }).collect(Collectors.toSet());
        if (!jwtMethods.keySet().containsAll(authenticatedMethods)) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] is missing at a JWT Authorization method. The class must define one or more methods annotated " + JWTAuthorizeMethod.class.getSimpleName() + " when [jwtEnabled] is set to [true], which is deprecated, or you are using a jwt based security scheme. Your action has defined the following security schemes [" + String.join((CharSequence)", ", securitySchemes) + "].Ensure that for each execute method in your action such as post, put, get and delete that a method is configured to authorize the JWT.");
        }
        return jwtMethods;
    }

    protected Map<String, Annotation> findResultConfigurations(Class<?> actionClass) {
        HashMap<String, Annotation> resultConfigurations = new HashMap<String, Annotation>();
        while (actionClass != Object.class) {
            Map<String, Annotation> resultsForClass = this.addResultsForClass(actionClass);
            resultsForClass.forEach(resultConfigurations::putIfAbsent);
            actionClass = actionClass.getSuperclass();
        }
        return resultConfigurations;
    }

    protected List<ScopeField> findScopeFields(Class<?> actionClass) {
        ArrayList<ScopeField> scopeFields = new ArrayList<ScopeField>();
        while (actionClass != Object.class) {
            Field[] fields;
            for (Field field : fields = actionClass.getDeclaredFields()) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = field.getAnnotations()) {
                    Class<? extends Annotation> type = annotation.annotationType();
                    if (!type.isAnnotationPresent(ScopeAnnotation.class)) continue;
                    scopeFields.add(new ScopeField(field, annotation));
                }
            }
            actionClass = actionClass.getSuperclass();
        }
        return scopeFields;
    }

    protected Field findUnknownParametersField(Class<?> actionClass) {
        List<Field> unknownParameters = ReflectionUtils.findAllFieldsWithAnnotation(actionClass, UnknownParameters.class);
        if (unknownParameters.size() > 1) {
            throw new PrimeException("The action class [" + String.valueOf(actionClass) + "] has more than one field annotated with " + UnknownParameters.class.getSimpleName() + ". This annotation may only be used once in the action class.");
        }
        if (unknownParameters.size() == 1) {
            return unknownParameters.get(0);
        }
        return null;
    }

    protected void verify(Method method) {
        if (method.getReturnType() != String.class || method.getParameterTypes().length != 0) {
            throw new PrimeException("The action class [" + String.valueOf(method.getDeclaringClass()) + "] has defined an execute method named [" + method.getName() + "] that is invalid. Execute methods must have zero parameters and return a String like this:\n\npublic String execute() {\n  return \"success\"\n}");
        }
    }

    private Map<Class<?>, List<Method>> findAllPreRenderMethods(Class<?> actionClass) {
        HashMap result = new HashMap();
        for (Method method : ReflectionUtils.findAllMethodsWithAnnotation(actionClass, PreRenderMethod.class)) {
            for (Class<?> clazz : method.getAnnotation(PreRenderMethod.class).value()) {
                if (clazz.getAnnotation(ResultAnnotation.class) == null) {
                    throw new PrimeException("The request annotation [" + clazz.getSimpleName() + "] must also have the @ResultAnnotation annotation to be properly considered as a result class type.");
                }
                result.computeIfAbsent(clazz, key -> new ArrayList()).add(method);
            }
        }
        return result;
    }

    private List<String> findSecuritySchemes(Class<?> actionClass) {
        ArrayList<String> securitySchemes = new ArrayList<String>(Arrays.asList(actionClass.getAnnotation(Action.class).scheme()));
        if (!securitySchemes.contains("jwt") && actionClass.getAnnotation(Action.class).jwtEnabled()) {
            securitySchemes.add(0, "jwt");
        }
        return securitySchemes;
    }

    private Map<Class<?>, Object> getAdditionalConfiguration(Class<?> actionClass) {
        HashMap additionalConfiguration = new HashMap();
        for (ActionConfigurator configurator : this.configurators) {
            Object config = configurator.configure(actionClass);
            if (config == null) continue;
            additionalConfiguration.put(config.getClass(), config);
        }
        return additionalConfiguration;
    }
}

